% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.mean2}
\alias{ci.ratio.mean2}
\title{Confidence interval for a 2-group mean ratio}
\usage{
ci.ratio.mean2(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Mean1 - estimated mean for group 1
\item Mean2 - estimated mean for group 2
\item Mean1/Mean2- estimated mean ratio
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of population means of
ratio-scale measurements in a 2-group design. Equality of variances
is not assumed.
}
\examples{
y2 <- c(32, 39, 26, 35, 43, 27, 40, 37, 34, 29, 49, 42, 40)
y1 <- c(36, 44, 47, 42, 49, 39, 46, 31, 33, 48)
ci.ratio.mean2(.05, y1, y2)

# Should return:
#
# Mean1    Mean2 Mean1/Mean2        LL       UL
#  41.5 36.38462    1.140592 0.9897482 1.314425


}
\references{
\insertRef{Bonett2020b}{statpsych}
}
