% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{adj.se}
\alias{adj.se}
\title{Adjusted standard errors for slope coefficients in an exploratory analysis}
\usage{
adj.se(alpha, mse1, mse2, dfe1, se, b)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{mse1}{mean squared error in full model}

\item{mse2}{mean squared error in selected model}

\item{dfe1}{error df in full model}

\item{se}{vector of slope standard errors in selected model}

\item{b}{vector of estimated slopes in selected model}
}
\value{
Returns adjusted standard error, t-statistic, p-value, and confidence interval
for each slope coefficient
}
\description{
Computes an adjusted standard error in a general linear model after one or
more predictor variables with nonsignificant slopes have been dropped from
the model. The adjusted standard errors are then used to compute adjusted
t-values, p-values, and confidence intervals. The mean square error and
error degrees of freedom from the full model are used to compute the
adjusted standard errors. These adjusted results are less susceptible to
the negative effects of an exploratory model selection.
}
\examples{
se <- c(1.57, 3.15, 0.982)
b <- c(3.78, 8.21, 2.99)
adj.se(.05, 10.26, 8.37, 114, se, b)

# Should return:
#      Estimate   adj SE        t  df           p        LL        UL
# [1,]     3.78 1.738243 2.174609 114 0.031725582 0.3365531  7.223447
# [2,]     8.21 3.487559 2.354082 114 0.020279958 1.3011734 15.118827
# [3,]     2.99 1.087233 2.750102 114 0.006930554 0.8362007  5.143799
 

}
