% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createQTLMPP.R
\name{summary.QTLMPP}
\alias{summary.QTLMPP}
\title{Summary function for the class \code{QTLMPP}}
\usage{
\method{summary}{QTLMPP}(object, ...)
}
\arguments{
\item{object}{An object of class \code{QTLMPP}.}

\item{...}{Not used.}
}
\description{
Gives a summary for an object of S3 class \code{QTLMPP}.
}
\examples{
\dontrun{
## Read phenotypic data.
pheno <- read.delim(system.file("extdata/multipop", "AxBxCpheno.txt",
                               package = "statgenMPP"))
## Rename first column to genotype.
colnames(pheno)[1] <- "genotype"

## Compute IBD probabilities for simulated population - AxB, AxC.
ABC <- calcIBDMPP(crossNames = c("AxB", "AxC"),
                  markerFiles = c(system.file("extdata/multipop", "AxB.txt",
                                              package = "statgenMPP"),
                                  system.file("extdata/multipop", "AxC.txt",
                                              package = "statgenMPP")),
                  pheno = pheno,
                  popType = "F4DH",
                  mapFile = system.file("extdata/multipop", "mapfile.txt",
                                        package = "statgenMPP"),
                  evalDist = 5)

## Multi-QTL Mapping.
ABC_MQM <- selQTLMPP(ABC, trait = "pheno")

## Print summary.
summary(ABC_MQM)
}

}
