% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeIBDs.R
\name{writeIBDs}
\alias{writeIBDs}
\title{Write IBD probabilities to file.}
\usage{
writeIBDs(IBDprob, outFile, decimals = 6, minProb = 0, compress = FALSE)
}
\arguments{
\item{IBDprob}{An object of class \code{IBDprob} containing the IBD
probabilities.}

\item{outFile}{A character string specifying the path of the output file.}

\item{decimals}{An integer value specifying the number of decimals to include
in writing the output file.}

\item{minProb}{A numerical value between zero and 1 / number of parents,
specifying the minimum probability cutoff value. Probabilities below this
cutoff are set to zero and other probabilities are rescaled to make sure that
the probabilities sum up to one.}

\item{compress}{Should the output be compressed to .gz format?}
}
\value{
No output. The output file is created as a result of calling this
function.
}
\description{
Writes IBD probabilities to a plain text, tab-delimited .txt or .ibd file.
Information about the file format can be found in the vignette (
\code{vignette("IBDFileFormat", package = "statgenIBD")}).
}
\examples{
## Compute IBD probabilities for Steptoe Morex.
SxMIBD <- calcIBD(popType = "DH",
                 markerFile = system.file("extdata/SxM", "SxM_geno.txt",
                                         package = "statgenIBD"),
                 mapFile = system.file("extdata/SxM", "SxM_map.txt",
                                      package = "statgenIBD"))

## Write IBDs to temporary files.
writeIBDs(IBDprob = SxMIBD, outFile = tempfile(fileext = ".txt"))

## Write IBDs to file, set values <0.05 to zero and only print 3 decimals.
writeIBDs(IBDprob = SxMIBD, outFile = tempfile(fileext = ".txt"),
         decimals = 3, minProb = 0.05)

}
