% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createVarCov.R
\name{plot.varCov}
\alias{plot.varCov}
\title{Plot function for class varCov}
\usage{
\method{plot}{varCov}(x, title = paste("Heatmap for model:", x$choice), ..., output = TRUE)
}
\arguments{
\item{x}{An object of class varCov}

\item{title}{A character string used a title for the plot.}

\item{...}{Not used.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a ggplot object is invisibly returned.}
}
\description{
Function for plotting a heatmap of the correlation matrix for objects of
class varCov.
}
\examples{
\donttest{
if (requireNamespace("asreml", quietly = TRUE)) {
  ## Select the best variance-covariance model using asreml for modeling.
  geVarCov <- gxeVarCov(TD = TDMaize, trait = "yld", engine = "asreml")

  ## Create a heatmap of the correlation matrix for the best model.
  plot(geVarCov)
  }
}

}
\seealso{
Other varCov: 
\code{\link{fitted.varCov}()},
\code{\link{gxeVarCov}()},
\code{\link{report.varCov}()},
\code{\link{residuals.varCov}()}
}
\concept{varCov}
