% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtile.R
\name{xtile}
\alias{xtile}
\title{Bin variable in groups (similar to Stata xtile)}
\usage{
xtile(x, n = NULL, probs = NULL, cutpoints = NULL, wt = NULL)
}
\arguments{
\item{x}{A vector}

\item{n}{A numeric specifying number of quantiles. Can be used instead of cutpoints}

\item{probs}{A vector of probabilities that an be used instead of cutpoints. Quantiles are computed as the inverse of the empirical distribution function (type = 1)}

\item{cutpoints}{Cutpoints to use when \code{nq} is not specified.  For instance \code{cutpoints = 0.4} creates two groups, one for observations equal or below 0.4, one for observations superior to 0.4.}

\item{wt}{A variable specifying weight in case the option n_quantiles is specified.}
}
\value{
An integer vector representing groups corresponding to cutpoints. Includes missing values when present in the original vector.
}
\description{
Bin variable in groups (similar to Stata xtile)
}
\examples{
x <- c(NA, 1:10)                   
xtile(x, n = 3) # 3 groups based on terciles
xtile(x, probs = c(0.3, 0.7)) # 3 groups based on two quantiles
xtile(x, cutpoints = c(2, 3)) # 3 groups based on two cutpoints
}
