% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.panel.R
\name{is.panel}
\alias{is.panel}
\title{Check whether a data.frame is a panel}
\usage{
is.panel(x, ...)
}
\arguments{
\item{x}{a data frame}

\item{...}{a time variable}
}
\value{
The function \code{is.panel} check that there are no duplicate combinations of the variables in ... and that no observation is missing for the last variable in ... (the time variable).
}
\description{
Check whether a data.frame is a panel
}
\examples{
library(dplyr)
df <- tibble(
    id1    = c(1, 1, 1, 2, 2),
    id2   = 1:5,
    year  = c(1991, 1993, NA, 1992, 1992),
    value = c(4.1, 4.5, 3.3, 3.2, 5.2)
)
df \%>\% group_by(id1) \%>\% is.panel(year)
df1 <- df \%>\% filter(!is.na(year))
df1 \%>\% is.panel(year)
df1 \%>\% group_by(id1) \%>\% is.panel(year)
df1 \%>\% group_by(id1, id2) \%>\% is.panel(year)
}
