% Generated by roxygen2 (4.0.2): do not edit by hand
\name{join}
\alias{join}
\title{Join two data.tables together}
\usage{
join(x, y, on = intersect(names(x), names(y)), type = "outer", check = m ~
  m, gen = FALSE, inplace = FALSE)
}
\arguments{
\item{x}{The master data.table}

\item{y}{The using data.table}

\item{on}{Character vectors specifying variables to match on. Default to common names between x and y.}

\item{type}{The type of (SQL) join among "outer" (default), "left", "right", "inner", "semi", "anti" and "cross".}

\item{check}{A formula checking for the presence of duplicates. Specifying 1~m (resp m~1, 1~1) checks that joined variables uniquely identify observations in x (resp y, both).}

\item{gen}{Name of new variable to mark result, or the boolean FALSE (default) if no such variable should be created. The variable equals 1 for rows in master only, 2 for rows in using only, 3 for matched rows.}

\item{inplace}{A boolean. In case "type"= "left" and RHS of check is 1, the merge can be one in-place.}
}
\value{
A data.table that joins rows in master and using datases. In order to avoid duplicates, identical variable names not joined are renamed with .x and .y suffixes. Importantly, if x or y are not keyed, the join may change their row orders.
}
\description{
Join two data.tables together
}
\examples{
library(data.table)
x <- data.table(a = rep(1:2, each = 3), b=1:6)
y <- data.table(a = 0:1, bb = 10:11)
join(x, y, type = "outer")
join(x, y, type = "left", gen = "_merge")
join(x, y, type = "right", gen = "_merge")
join(x, y, type = "inner", check = m~1)
join(x, y, type = "semi")
join(x, y, type = "anti")
join(x, y, type = "left", check = m~1, inplace = TRUE)
}

