% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_query_filter_dimension.R
\name{filter_dimension}
\alias{filter_dimension}
\alias{filter_dimension.dimensional_query}
\title{Filter dimension}
\usage{
filter_dimension(dq, name = NULL, ...)

\method{filter_dimension}{dimensional_query}(dq, name = NULL, ...)
}
\arguments{
\item{dq}{A \code{dimensional_query} object.}

\item{name}{A string, name of the dimension.}

\item{...}{Conditions, defined in exactly the same way as in \code{dplyr::filter}.}
}
\value{
A \code{dimensional_query} object.
}
\description{
Allows you to define selection conditions for dimension rows.
}
\details{
Conditions can be defined on any attribute of the dimension (not only on
attributes selected in the query for the dimension). The selection is made
based on the function \code{dplyr::filter}. Conditions are defined in exactly the
same way as in that function.
}
\examples{
library(tidyr)

dq <- dimensional_query(ms_mrs) \%>\%
  filter_dimension(name = "when", when_happened_week <= "03") \%>\%
  filter_dimension(name = "where", city == "Boston")

}
\seealso{


Other query functions: 
\code{\link{dimensional_query}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()}
}
\concept{query functions}
