% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgb_to_greyscale.R
\name{rgb_to_greyscale}
\alias{rgb_to_greyscale}
\title{Convert RGB to greyscale}
\usage{
rgb_to_greyscale(x, rgb = 1:3, coefs = c(0.3, 0.59, 0.11))
}
\arguments{
\item{x}{A three-dimensional \code{stars} object with RGB values}

\item{rgb}{Indices of RGB bands, default is \code{c(1, 2, 3)}}

\item{coefs}{RGB weights, default is \code{c(0.30,0.59,0.11)}}
}
\value{
A two-dimensional \code{stars} object greyscale values
}
\description{
Convert a 3-band RGB raster to 1-band greyscale raster. Based on \code{wvtool::rgb2gray}.
}
\examples{
data(landsat)
plot(landsat, rgb = 1:3)
landsat_grey = rgb_to_greyscale(landsat)
plot(landsat_grey, breaks = "equal")

}
