#' Attention Deficit Hyperactivity Disorder (ADHD)
#'
#' A data set consists of 221 patients with ADHD
#'
#' @format A data frame with 221 rows and 10 variables, which is a
#' mixture of both discrete and continuous variables:
#' \describe{
#' \item{Gender}{gender of patients}
#' \item{AD}{the attention deficit measure}
#' \item{HI}{the assessment of hyperactivity/impulsivity}
#' \item{Aggression}{the measure of aggressive behavior}
#' \item{Medication}{the medication status of patients}
#' \item{Handedness}{wheteher a patient uses the right or the left hand}
#' }
#' @references
#' Cao, Q., Zang, Y., Sun, L., Sui, M., Long, X., Zou, Q., & Wang, Y. (2006).
#' Abnormal neural activity in children with attention deficit hyperactivity
#' disorder: a resting-state functional magnetic resonance imaging study.
#' \emph{Neuroreport}, 17(10), 1033-1036.
"adhd"
