% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stab_reg.R
\name{stab_reg}
\alias{stab_reg}
\alias{stab_reg.default}
\title{Individual Regression for each Genotype}
\usage{
stab_reg(.data, .y, .rep, .gen, .env)

\method{stab_reg}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Additive ANOVA
}
\description{
Individual Regression for each Genotype in Genotypes by Environment Interaction (GEI)
}
\examples{

data(ge_data)
Yield.StabReg <-
        stab_reg(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
          )

Yield.StabReg

}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
