% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_spectral_cor}
\alias{eem_spectral_cor}
\title{Multiply EEMs with spectral correction vectors (Emission and Excitation)}
\usage{
eem_spectral_cor(eem_list, Excor, Emcor)
}
\arguments{
\item{eem_list}{eemlist}

\item{Excor}{data frame, first column wavelengths, second column excitation correction}

\item{Emcor}{data frame, first column wavelengths, second column emission correction}
}
\value{
eemlist
}
\description{
Multiply EEMs with spectral correction vectors (Emission and Excitation)
}
\examples{
eems <- system.file("extdata/EEMs",package="staRdom")
eem_list <- eem_read_csv(eems)

excorfile <- system.file("extdata/CorrectionFiles/xc06se06n.csv",package="staRdom")
Excor <- data.table::fread(excorfile)
emcorfile <- system.file("extdata/CorrectionFiles/mcorrs_4nm.csv",package="staRdom")
Emcor <- data.table::fread(emcorfile)

# adjust range of EEMs to cover correction vectors
eem_list <- eem_range(eem_list,ex = range(Excor[,1]), em = range(Emcor[,1]))

eem_list_sc <- eem_spectral_cor(eem_list,Excor,Emcor)
}
