% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RandHIE}
\alias{RandHIE}
\title{RAND Health Insurance Experiment}
\format{
An object of class \code{data.frame} with 20190 rows and 45 columns.
}
\source{
\url{http://cameron.econ.ucdavis.edu/mmabook/mmadata.html}
}
\usage{
RandHIE
}
\description{
'The RAND Health Insurance Experiment (RAND HIE) was a comprehensive
study of health care cost, utilization and outcome in the United States.
It is the only randomized study of health insurance, and the only study
which can give definitive evidence as to the causal effects of different
health insurance plans. For more information about the database visit:
\url{https://en.wikipedia.org/w/index.php?title=RAND_Health_Insurance_Experiment&oldid=110166949}
accessed september 09, 2019). This data frame contains the following columns:
\itemize{
\item{plan: HIE plan number.}
 \item{site: Participant's  place of residence
 when the participant was initially enrolled.}
 \item{coins: Coinsurance rate.}
 \item{tookphys: Took baseline physical.}
 \item{year: Study year.}
 \item{zper: Person identifier.}
 \item{black: 1 if race of household head is black.}
 \item{income: Family income.}
 \item{xage: Age in years.}
 \item{female: 1 if person is female.}
 \item{educdec: Education of household head in years.}
 \item{time: Time eligible during the year.}
 \item{outpdol: Outpatient expenses:
 all covered outpatient medical services
 excluding dental care, outpatient psychotherapy,
 outpatient drugs or supplies.}
 \item{drugdol: Drug expenses:
 all covered outpatient and dental drugs.}
 \item{suppdol: Supply expenses:
 all covered outpatient supplies including dental.}
 \item{mentdol: Psychotherapy expenses:
 all covered outpatient psychotherapy services including injections
 excluding charges for visits in excess of 52 per year,
 prescription drugs, and inpatient care.}
 \item{inpdol: Inpatient expenses:
 all covered inpatient expenses in a hospital, mental hospital,
 or nursing home,
 excluding outpatient care and renal dialysis.}
 \item{meddol: Medical expenses:
 all covered inpatient and outpatient services,
 including drugs, supplies, and inpatient costs of newborns
 excluding dental care and outpatient psychotherapy.}
 \item{totadm: Hospital admissions:
 annual number of covered hospitalizations.}
 \item{inpmis: Incomplete Hospital Records:
 missing inpatient records.}
 \item{mentvis: Psychotherapy visits:
 indicates the annual number of outpatient visits for psychotherapy.
 It includes billed visits only.
 The limit was 52 covered visits per person per year.
 The count includes an initial visit to a psychiatrist or psychologist.}
 \item{mdvis: Face-to-Face visits to physicians:
 annual covered outpatient visits with physician providers
 (excludes dental, psychotherapy, and
 radiology/anesthesiology/pathology-only visits).}
 \item{notmdvis: Face-to-Face visits to nonphysicians:
 annual covered outpatient visits with nonphysician providers
 such as speech and physical therapists, chiropractors,
 podiatrists, acupuncturists, Christian Science etc.
 (excludes dental, healers, psychotherapy,
 and radiology/anesthesiology/pathology-only visits).}
 \item{num: Family size.}
 \item{mhi: Mental health index.}
 \item{disea: Number of chronic diseases.}
 \item{physlm: Physical limitations.}
 \item{ghindx: General health index.}
 \item{mdeoff: Maximum expenditure offer.}
 \item{pioff: Participation incentive payment.}
 \item{child: 1 if age is less than 18 years.}
 \item{fchild: \code{female * child}.}
 \item{lfam: log of \code{num} (family size).}
 \item{lpi: log of \code{pioff} (participation incentive payment).}
 \item{idp: 1 if individual deductible plan.}
 \item{logc: \code{log(coins+1)}.}
 \item{fmde: 0 if \code{idp=1},
 \code{ln(max(1,mdeoff/(0.01*coins)))} otherwise.}
 \item{hlthg: 1 if self-rated health is good
 -- baseline is excellent self-rated health.}
 \item{hlthf: 1 if self-rated health is fair
 -- baseline is excellent self-rated health.}
 \item{hlthp: 1 if self-rated health is poor
 -- baseline is excellent self-rated health.}
 \item{xghindx: \code{ghindx} (general healt index)
 with imputations of missing values.}
 \item{linc: log of \code{income} (family income).}
 \item{lnum: log of \code{num} (family size).}
 \item{lnmeddol: log of \code{meddol} (medical expenses).}
 \item{binexp: 1 if \code{meddol} > 0.}
 }
}
\examples{
##Cameron and Trivedi (2005): Section 16.6
data(RandHIE)
subsample <- RandHIE$year == 2 & !is.na( RandHIE$educdec )
selectEq <- binexp ~ logc + idp + lpi + fmde + physlm + disea +
  hlthg + hlthf + hlthp + linc + lfam + educdec + xage + female +
  child + fchild + black
  outcomeEq <- lnmeddol ~ logc + idp + lpi + fmde + physlm + disea +
  hlthg + hlthf + hlthp + linc + lfam + educdec + xage + female +
  child + fchild + black
  cameron <- HeckmanCL(selectEq, outcomeEq, data = RandHIE[subsample, ])
  summary(cameron)

}
\references{
{
  \insertRef{cameron2005}{ssmodels}

  \insertRef{ssmrob}{ssmodels}

  \insertRef{sampleSelection}{ssmodels}

  \insertRef{wikiRand}{ssmodels}
}
}
\keyword{RandHIE}
