% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.fitdists}
\alias{subset.fitdists}
\title{Subset fitdists Object}
\usage{
\method{subset}{fitdists}(x, select = names(x), delta = Inf, ...)
}
\arguments{
\item{x}{The object.}

\item{select}{A character vector of the distributions to select.}

\item{delta}{A non-negative number specifying the maximum absolute AIC difference cutoff.
Distributions with an absolute AIC difference greater than delta are excluded from the calculations.}

\item{...}{Unused.}
}
\description{
Select a subset of distributions from a fitdists object.
The Akaike Information-theoretic Criterion differences are calculated after
selecting the distributions named in select.
}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
subset(fits, c("gamma", "lnorm"))
}
