% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp.R
\name{ssd_hp}
\alias{ssd_hp}
\alias{ssd_hp.fitdists}
\alias{ssd_hp.fitburrlioz}
\title{Hazard Proportion}
\usage{
ssd_hp(x, ...)

\method{ssd_hp}{fitdists}(
  x,
  conc = 1,
  average = TRUE,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  multi_est = TRUE,
  ci_method = "weighted_samples",
  parametric = TRUE,
  delta = 9.21,
  samples = FALSE,
  save_to = NULL,
  control = NULL,
  ...
)

\method{ssd_hp}{fitburrlioz}(
  x,
  conc = 1,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  parametric = FALSE,
  samples = FALSE,
  save_to = NULL,
  ...
)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{conc}{A numeric vector of concentrations to calculate the hazard proportions for.}

\item{average}{A flag specifying whether to provide model averaged values as opposed to a value for each distribution.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level of the interval.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the confidence limits. A value of 10,000 is recommended for official guidelines.}

\item{min_pboot}{A number between 0 and 1 of the minimum
proportion of bootstrap samples that must successfully fit (return a likelihood)
to report the confidence intervals.}

\item{multi_est}{A flag specifying whether to treat the distributions as constituting a single distribution (as opposed to taking the mean) when calculating model averaged estimates.}

\item{ci_method}{A string specifying which method to use for estimating the bootstrap values.
Possible values are "multi_free" and "multi_fixed" which treat the distributions as constituting a single distribution but differ in whether the model weights are fixed and "weighted_samples" and "weighted_arithmetic" take bootstrap samples from each distribution proportional to its weight versus calculating the weighted arithmetic means of the lower and upper confidence limits.}

\item{parametric}{A flag specifying whether to perform parametric bootstrapping as opposed to non-parametrically resampling the original data with replacement.}

\item{delta}{A non-negative number specifying the maximum absolute AIC difference cutoff.
Distributions with an absolute AIC difference greater than delta are excluded from the calculations.}

\item{samples}{A flag specfying whether to include a numeric vector of the bootstrap samples as a list column in the output.}

\item{save_to}{NULL or a string specifying a directory to save where the bootstrap datasets and parameter estimates (when successfully converged) to.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}
}
\value{
A tibble of corresponding hazard proportions.
}
\description{
Calculates proportion of species affected at specified concentration(s)
with quantile based bootstrap confidence intervals for
individual or model-averaged distributions
using parametric or non-parametric bootstrapping.
For more information see the inverse function \code{\link[=ssd_hc]{ssd_hc()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ssd_hp(fitdists)}: Hazard Proportions for fitdists Object

\item \code{ssd_hp(fitburrlioz)}: Hazard Proportions for fitburrlioz Object

}}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_hp(fits, conc = 1)

fit <- ssd_fit_burrlioz(ssddata::ccme_boron)
ssd_hp(fit)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}}
}
