% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{ssd_fit_dists}
\alias{ssd_fit_dists}
\title{Fit Distributions}
\usage{
ssd_fit_dists(data, left = "Conc", right = left, weight = NULL,
  dists = c("lnorm", "llog", "gompertz", "lgumbel", "gamma", "weibull"),
  silent = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the left concentration values.}

\item{right}{A string of the column in data with the right concentration values.}

\item{weight}{A string of the column in data with the weightings (or NULL)}

\item{dists}{A character vector of the distributions to fit.}

\item{silent}{A flag indicating whether fits should fail silently.}
}
\value{
An object of class fitdists (a list of \code{\link[fitdistrplus]{fitdist}} objects).
}
\description{
Fits one or more distributions to species sensitivity data.
}
\details{
By default the 'lnorm', 'llog', 'gompertz', 'lgumbel', 'gamma' and 'weibull'
distributions are fitted to the data.
The ssd_fit_dist and \code{\link{ssd_fit_dist}} functions have also been
tested with the 'pareto' distribution.

If weight specifies a column in the data frame with positive integers,
weighted estimation occurs.
However, currently only the resultant parameter estimates are available (via coef).

If the `right` argument is different to the `left` argument then the data are considered to be censored.
It may be possible to use artificial censoring to improve the estimates in the extreme tails
(Liu et al 2018).
}
\examples{
ssd_fit_dists(boron_data)
data(fluazinam)
ssd_fit_dists(fluazinam, left = "left", right = "right")
}
\references{
Liu, Y., Salibián-Barrera, M., Zamar, R.H., and Zidek, J.V. 2018. Using artificial censoring to improve extreme tail quantile estimates. Journal of the Royal Statistical Society: Series C (Applied Statistics).
}
\seealso{
\code{\link{ssd_fit_dist}}
}
