% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{congruency}
\alias{congruency}
\title{Mouse-tracking experiment of a memory task}
\format{A long-format dataframe of 728 observations containing 
  information on the following variables.
\describe{
 \item{sbj}{The ID number of participants}
 \item{trial}{The ID number of trials}
 \item{congruency}{A factor of levels \code{congruent}, \code{incongruent}}
 \item{plausibility}{A factor of levels \code{plausible}, \code{implausible}}
 \item{timestep}{The ID number of the recorded x-y trajectories} 
 \item{x}{The recorded x-trajectories}
 \item{y}{The recorded y-trajectories}
}}
\source{
Coco, M. I., & Duran, N. D. (2016). When expectancies collide: 
Action dynamics reveal the interaction between stimulus plausibility and congruency. 
\emph{Psychonomic bulletin & review}, 23(6), 1920-1931.
}
\usage{
congruency
}
\description{
This dataset contains a subset of data originally presented in Coco & Duran (2016). In this task 
participants see sentence and scene pairs that varied in plausibility and are requested 
to classify the pairs as congruent or incongruent. The experimental variables are \emph{congruency} with two categorical levels (i.e., congruent, incongruent) and
\emph{plausibility} with two categorical levels (i.e., plausible, implausible). Participants have to classify each stimulus as belonging to one of these four levels. 

The dataset contains two participants (I=2), each measured along three trials, two categorical variables (Q=2) each with two levels (K=2). The total number of trials is J=12.
Mouse-tracking trajectories are raw-data, i.e. they have not been previously pre-processed.
}
\keyword{datasets}
