% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_maturity.R
\name{change_maturity}
\alias{change_maturity}
\title{Alter a control file to specify the SS3 maturity option}
\usage{
change_maturity(ctl_file_in = "em.ctl", ctl_file_out = "em.ctl",
  maturity_option = 1L)
}
\arguments{
\item{ctl_file_in}{A string providing the path to the input SS3 \code{.ctl} file.}

\item{ctl_file_out}{A string providing the path to the output SS3 \code{.ctl} file.}

\item{maturity_option}{*An integer specifying \code{1} for length logistic,
\code{2} for age logistic, \code{3} to read age-maturity for each female,
\code{4} to read age-fecundity for each female growth patern, or \code{5}
to read empirical age-fecundity and body weight-at-age from a separate
file (\code{wtatage.ss}).}
}
\value{
A modified SS3 control file.
}
\description{
Alter a control file to specify the maturity option in SS3. You could use
this function to, for example, tell SS3 to read empirical age-fecundity and
body weight-at-age data from \code{wtatage.ss}.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\examples{
# Create a temporary folder for the output:
temp_path <- file.path(tempdir(), "ss3sim-maturity-example")
dir.create(temp_path, showWarnings = FALSE)
wd <- getwd()
setwd(temp_path)

# Locate the package data:
ctlfile <- system.file("extdata", "models", "cod-em",
 "codEM.ctl", package = "ss3sim")

# Change the maturity option from 1 to 5:
change_maturity(ctlfile, "test.ctl", maturity_option = 5L)

unlink("test.ctl")
setwd(wd)
}
\seealso{
Other change functions: \code{\link{change_data}},
  \code{\link{change_em_binning}}, \code{\link{change_e}},
  \code{\link{change_f}}, \code{\link{change_retro}},
  \code{\link{change_tv}}
}
\author{
Sean C. Anderson
}
