% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_survey.r
\name{as_survey}
\alias{as_survey}
\alias{as_survey.tbl_svy}
\alias{as_survey.data.frame}
\alias{as_survey.tbl_lazy}
\alias{as_survey.survey.design2}
\alias{as_survey.svyrep.design}
\alias{as_survey.twophase2}
\title{Create a tbl_svy from a data.frame}
\usage{
as_survey(.data, ...)

\method{as_survey}{tbl_svy}(.data, ...)

\method{as_survey}{data.frame}(.data, ...)

\method{as_survey}{tbl_lazy}(.data, ...)

\method{as_survey}{survey.design2}(.data, ...)

\method{as_survey}{svyrep.design}(.data, ...)

\method{as_survey}{twophase2}(.data, ...)
}
\arguments{
\item{.data}{a data.frame or an object from the survey package}

\item{...}{other arguments, see other functions for details}
}
\value{
a tbl_svy
}
\description{
\code{as_survey} can be used to create a \code{tbl_svy} using design information
(\code{\link{as_survey_design}}), replicate weights (\code{\link{as_survey_rep}}),
or a two phase design (\code{\link{as_survey_twophase}}), or an object created by the
survey package.
}
\details{
See \code{vignette("databases", package = "dplyr")}
for more information on setting up databases in dplyr.
}
\examples{
# Examples from ?survey::svydesign
library(survey)
library(dplyr)
data(api)

# stratified sample
dstrata <- apistrat \%>\%
  as_survey(strata = stype, weights = pw)

# Examples from ?survey::svrepdesign
data(scd)
# use BRR replicate weights from Levy and Lemeshow
scd$rep1 <- 2 * c(1, 0, 1, 0, 1, 0)
scd$rep2 <- 2 * c(1, 0, 0, 1, 0, 1)
scd$rep3 <- 2 * c(0, 1, 1, 0, 0, 1)
scd$rep4 <- 2 * c(0, 1, 0, 1, 1, 0)

scdrep <- scd \%>\%
  as_survey(type = "BRR", repweights = starts_with("rep"),
                    combined_weights = FALSE)

# Examples from ?survey::twophase
# two-phase simple random sampling.
data(pbc, package="survival")

pbc <- pbc \%>\%
  mutate(randomized = !is.na(trt) & trt > 0,
         id = row_number())
d2pbc <- pbc \%>\%
  as_survey(id = list(id, id), subset = randomized)

# dplyr 0.7 introduced new style of NSE called quosures
# See `vignette("programming", package = "dplyr")` for details
st <- quo(stype)
wt <- quo(pw)
dstrata <- apistrat \%>\%
  as_survey(strata = !!st, weights = !!wt)
}
