% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_srcpkgs.R
\name{find_srcpkgs}
\alias{find_srcpkgs}
\title{finds all available source packages starting from the project root}
\usage{
find_srcpkgs(
  root = get_project_root(),
  srcpkgs_paths = find_srcpkgs_paths(root, prune = prune),
  prune = TRUE
)
}
\arguments{
\item{root}{directory from where to search for source packages}

\item{srcpkgs_paths}{paths to the source packages folders}

\item{prune}{whether to report packages contained inside another package (e.g. in tests/)}
}
\value{
a "srcpkgs" object (or NULL if none found), a named list of "srcpkg" objects, that essentially are
devtools "package" objects. The list is named after the package names.
}
\description{
N.B: the \emph{hidden} files and directories are ignored.
In general, this function is not used directly, instead you should use \code{\link[=get_srcpkgs]{get_srcpkgs()}}
}
\examples{
find_srcpkgs('.')
}
