% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-dist.R
\name{dist}
\alias{dist}
\alias{dist.default}
\alias{dist.qts_sample}
\title{QTS Distance Matrix Computation}
\usage{
dist(x, metric, ...)

\method{dist}{default}(
  x,
  metric = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  diag = FALSE,
  upper = FALSE,
  p = 2,
  ...
)

\method{dist}{qts_sample}(
  x,
  metric = c("l2", "normalized_l2", "pearson", "dtw"),
  is_domain_interval = FALSE,
  transformation = c("identity", "srvf"),
  warping_class = c("none", "shift", "dilation", "affine", "bpd"),
  rotation_invariance = FALSE,
  cluster_on_phase = FALSE,
  labels = NULL,
  ncores = 1L,
  ...
)
}
\arguments{
\item{x}{A numeric matrix, data frame, \link[stats:dist]{stats::dist} object or object of
class \link{qts_sample} specifying the sample on which to compute the pairwise
distance matrix.}

\item{metric}{A character string specifying the distance measure to be used.
This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"} or \code{"minkowski"} if \code{x} is not a QTS sample.
Otherwise, it must be one of \code{"l2"}, \code{"pearson"} or \code{"dtw"}.}

\item{...}{not used.}

\item{diag}{logical value indicating whether the diagonal of the
    distance matrix should be printed by \code{print.dist}.}

\item{upper}{logical value indicating whether the upper triangle of the
    distance matrix should be printed by \code{print.dist}.}

\item{p}{The power of the Minkowski distance.}

\item{is_domain_interval}{A boolean specifying whether the sample of curves
is defined on a fixed interval. Defaults to \code{FALSE}.}

\item{transformation}{A string specifying the transformation to apply to the
original sample of curves. Choices are no transformation (\code{transformation = "identity"}) or square-root velocity function \code{transformation = "srvf"}.
Defaults to \code{"identity"}.}

\item{warping_class}{A string specifying the class of warping functions.
Choices are no warping (\code{warping_class = "none"}), shift \code{y = x + b}
(\code{warping_class = "shift"}), dilation \code{y = ax} (\code{warping_class = "dilation"}), affine \code{y = ax + b} (\code{warping_class = "affine"}) or
boundary-preserving diffeomorphism (\code{warping_class = "bpd"}). Defaults to
\code{"none"}.}

\item{rotation_invariance}{A boolean value specifying whether the distance
should be invariant to rotation. This is only relevant when
\code{is_domain_interval} is \code{TRUE} and \code{transformation} is \code{"srvf"} and
\code{warped_class} is \code{"bpd"}. Defaults to \code{FALSE}.}

\item{cluster_on_phase}{A boolean specifying whether clustering should be
based on phase variation or amplitude variation. Defaults to \code{FALSE} which
implies amplitude variation.}

\item{labels}{A character vector specifying curve labels. Defaults to \code{NULL}
which uses sequential numbers as labels.}

\item{ncores}{An integer value specifying the number of cores to use for
parallel computation. Defaults to \code{1}.}
}
\value{
An object of class \link[stats:dist]{stats::dist}.
}
\description{
This function massages an input sample of quaternion time series to turn it
into a pairwise distance matrix.
}
\examples{
D <- dist(vespa64$igp[1:5])
}
