% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-prcomp.R
\name{prcomp.qts_sample}
\alias{prcomp.qts_sample}
\title{PCA for QTS Sample}
\usage{
\method{prcomp}{qts_sample}(x, M = 5, fit = FALSE, ...)
}
\arguments{
\item{x}{An object of class \link{qts_sample}.}

\item{M}{An integer value specifying the number of principal component to
compute. Defaults to \code{5L}.}

\item{fit}{A boolean specifying whether the resulting \code{prcomp_qts} object
should store a reconstruction of the sample from the retained PCs. Defaults
to \code{FALSE}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{prcomp_qts} which is a list with the following
components:
\itemize{
\item \code{tpca}: An object of class \code{MFPCAfit} as produced by the function
\code{\link[MFPCA:MFPCA]{MFPCA::MFPCA()}},
\item \code{var_props}: A numeric vector storing the percentage of variance explained
by each PC,
\item \code{mean_qts}: An object of class \link{qts} containing the mean QTS,
\item \code{principal_qts}: A list of \link{qts}s containing the required principal
components.
}
}
\description{
PCA for QTS Sample
}
\examples{
res_pca <- prcomp(vespa64$igp)
}
