#' sprex
#' 
#' @docType package
#' @name sprex-package
#' @aliases sprex
#' @title Calculate species richness and extrapolation metrics
#' @description Calculate species richness and expected number of species 
#'   primarily based on algorithms in Colwell, R.K., A. Chao, N.J. Gotelli, 
#'   S.-Y. Lin, C.X. Mao, R.L. Chazdon, and J.T. Longino. 2012. Models and 
#'   estimators linking individual-based and sample-based rarefaction, 
#'   extrapolation and comparison of assemblages. 
#'   Journal of Plant Ecology 5(1):3-21.
#' @keywords package
NULL

#' @docType data
#' @name osa.old.growth
#' @title Osa old growth
#' @usage data(osa.old.growth)
#' @references Janzen DH (1973) Sweep samples of tropical foliage insects: 
#'   effects of seasons, vegetation types, elevation, time of day, 
#'   and insularity. Ecology 54:687-708.
#' @keywords datasets
NULL

#' @docType data
#' @name osa.second.growth
#' @title Osa second growth
#' @usage data(osa.second.growth)
#' @references Janzen DH (1973) Sweep samples of tropical foliage insects: 
#'   description of study sites, with data on species abundances and size 
#'   distributions. Ecology 54:659-86.
#' @keywords datasets
NULL
