% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_gof_test.R
\name{mc_gof}
\alias{mc_gof}
\title{Monte Carlo goodness of fit test}
\usage{
mc_gof(pp, intsurf, alpha = 0.5, L = 20000, burnin = floor(0.1 * L),
  truncate = FALSE)
}
\arguments{
\item{pp}{Point pattern object of class \code{ppp}.}

\item{intsurf}{Object of class \code{intensity_surface}.}

\item{alpha}{Significance level for the goodness-of-fit test.}

\item{L}{Number of iterations requested; default is 20000.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{truncate}{Requests to truncate the components
of the mixture intensity to have all their mass
within the window of the intensity object intsurf. Default is FALSE.}
}
\description{
Performs a Monte Carlo test of goodness-of-fit for a given point pattern.
The entertained model is a Poisson with mixture of normals intensity
surface.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#mc_gof}
}
\details{
The test statistic is the average of the average distances between the
points assigned to the jth mixture component from the mean of the component.
The Monte Carlo test utilizes realizations from the posterior
predictive distribution to obtain the critical point,
i.e., the \code{a}th percentile of the distribution of the test statistic.
Make sure that L is large in order to get accurate results.
}
\examples{
\donttest{
# Create the intensity surface
intsurf1 <- normmix(ps = c(.3, .7), mus = list(c(0.2, 0.2), c(.8, .8)), sigmas =
 list(.01*diag(2), .01*diag(2)), lambda = 100, win = spatstat::square(1))
# Generate a point pattern
pp1 <- rsppmix(intsurf1)
# Assess goodness-of-fit. Since this is the right model, we should get gof. Make
# sure L is large for more accurate results
mc_gof(pp1, intsurf1, 0.05)
# Create another intensity surface
intsurf2 <- normmix(ps = c(.5, .5), mus = list(c(0.2, 0.8), c(.8, .2)), sigmas =
 list(.01*diag(2), .01*diag(2)), lambda = 100, win = spatstat::square(1))
# Assess goodness-of-fit against this Poisson. Since this is the wrong model,
# we should NOT get gof
mc_gof(pp1, intsurf2, 0.05)}

}
\seealso{
\code{\link{normmix}},
\code{\link{rsppmix}}
}
\author{
Jiaxun Chen, Sakis Micheas
}
