% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{PermutationLag}
\alias{PermutationLag}
\title{Permutation based p-value for spatial lag}
\usage{
PermutationLag(
  x,
  W,
  n = 999,
  seed = 1,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH",
  condition = 0,
  return.permutation = FALSE
)
}
\arguments{
\item{x}{A numerical vector.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{n}{The number of permutations to be conducted, set to 999 by default.}

\item{seed}{Random seed used. Default is 1.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}

\item{condition}{Value under null hypothesis to compare with, default is 0.}

\item{return.permutation}{Return permutations. Default is \code{FALSE}.}
}
\value{
A list containing the following:
\itemize{
\item lag, spatial lag.
\item p.val, permutation based p-value.
\item p.adj, adjusted p-values.
\item return.permutation, permutation used if returned.
}
}
\description{
Calculate permutation based p-value for spatial lag.
}
\keyword{internal}
