% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hnn.R
\name{HnnNeighbor}
\alias{HnnNeighbor}
\title{Hexagonal nearest neighbor}
\usage{
HnnNeighbor(dist.hnn, k, include.self = TRUE)
}
\arguments{
\item{dist.hnn}{A hexagonal nearest neighbor distance matrix.}

\item{k}{Number of neighbors.}

\item{include.self}{Whether to include self as 1st neighbor, default is \code{TRUE}.}
}
\value{
A list containing the following:
\itemize{
\item knn.idx, an n x k matrix for the nearest neighbor indice.
\item knn.dist, an n x k matrix for the nearest neighbor hexagonal distances.
\item dist.mat, a connectivity-based distance matrix.
}
}
\description{
Calculate hexagonal nearest neighbors.
}
\examples{
{
data.use <- quakes[1:100,]
dist.use <- as.matrix(dist(data.use[,1:2]))
res <- HnnNeighbor(dist.use, k = 10)
}
}
\references{
Middleton, L. & Sivaswamy, J.
Edge detection in a hexagonal-image processing framework. Image Vis. Comput. 19, 1071–1081 (2001)
}
\concept{hnn}
