% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{get_track_audio_analysis}
\alias{get_track_audio_analysis}
\title{Get a detailed audio analysis for a single track identified by its unique Spotify ID.}
\usage{
get_track_audio_analysis(id, authorization = get_spotify_access_token())
}
\arguments{
\item{id}{The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the track.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}
}
\value{
Returns a data frame of results containing track audio analysis data.
See \url{https://developer.spotify.com/documentation/web-api/reference/tracks/get-audio-analysis/} for more information.
}
\description{
Get a detailed audio analysis for a single track identified by its unique Spotify ID.
}
\seealso{
Other musicology functions: 
\code{\link{get_artist_audio_features}()},
\code{\link{get_genre_artists}()},
\code{\link{get_playlist_audio_features}()},
\code{\link{get_track_audio_features}()},
\code{\link{get_user_audio_features}()}
}
\concept{musicology functions}
