% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance.R
\name{deviance.spmod}
\alias{deviance.spmod}
\title{Fitted model deviance}
\usage{
\method{deviance}{spmod}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}
where \code{estmethod} is \code{"ml"} or \code{"reml"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The deviance.
}
\description{
Returns the deviance of a fitted model object.
}
\details{
For \code{spmod} objects estimated using \code{"ml"} or \code{"reml"},
the deviance is \eqn{(y - X \beta)^T V (y - X \beta)} for an inverse
covariance matrix \eqn{V}, analogous
to residual sums of (whitened) squares.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
deviance(spmod)
}
