% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_useful_fns.R
\name{getNodeData}
\alias{getNodeData}
\title{Retrieve the subset of the data found at a given terminal node}
\usage{
getNodeData(tree, node, dataType = "all")
}
\arguments{
\item{tree}{a splinetree object}

\item{node}{The number of the node to retrieve data from. Must be valid
number of a terminal node. Node numbers can be seen using stPrint(tree)
or treeSummary(tree).}

\item{dataType}{If "all", the data returned is from the original dataset (one row per individual observation
with original response values). If "flat", the data returned is the flattened data (one row per person/unit),
with individual spline coefficients instead of response values.}
}
\value{
A dataframe which holds all the data that falls into this node of the tree.
}
\description{
Given a terminal node number, this function returns the data belonging to
this terminal node. If the dataType argument is 'all', returns all rows of data from the
original dataset that fall in this node.  Otherwise, the flattened data that belongs to
this node is returned (one row of data per ID, original responses replaced by spline coefficients).
}
\examples{
\dontrun{
split_formula <- BMI ~ HISP + WHITE + BLACK + SEX +
  Num_sibs + HGC_FATHER + HGC_MOTHER
tree <- splineTree(split_formula, BMI~AGE, 'ID', nlsySample, degree=1,
  df=3, intercept=TRUE, cp=0.006, minNodeSize=20)
}
node6data <- getNodeData(tree, 6, dataType = 'all')
plot(BMI~AGE, data=node6data)
}
