% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_print.R
\name{treeSummary}
\alias{treeSummary}
\title{Prints the tree frame.}
\usage{
treeSummary(model)
}
\arguments{
\item{model}{A splinetree object.}
}
\value{
A dataframe. The number of rows is the same as the number of nodes in the tree.
The row names display the node labels of each node. The "var" attribute either displays
the split variable selected at each node, or <leaf> if this node is a terminal node. The "n"
attribute displays the number of individuals in the node. The "dev" attribute reports the
projected sum of squares at this node; terminal nodes have the smallest values for "dev" because
this is what the tree building process is supposed to minimize. The "coeffs" attribute displays
the coefficients predicted for each node.
}
\description{
Provides a similar output to model$frame, but with the redundant information of yval and
yval2 removed. Also omits the deviance, the complexity, and the weight. Useful for viewing
node numbers and for extracting coefficients for a given node.
}
\examples{
\donttest{
nlsySubset <- nlsySample[nlsySample$ID \%in\% sample(unique(nlsySample$ID), 400),]
split_formula <- ~HISP + WHITE + BLACK + SEX + Num_sibs + HGC_FATHER + HGC_MOTHER
tree <- splineTree(split_formula, BMI~AGE, idvar = "ID",
   data = nlsySubset, degree = 1, df = 3,
   intercept = TRUE, cp = 0.005)
}
treeSummary(tree)
}
