% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibs.R
\name{ibs}
\alias{ibs}
\title{Integral of B-Spline Basis for Polynomial Splines}
\usage{
ibs(x, df = NULL, knots = NULL, degree = 3, intercept = FALSE,
        Boundary.knots = range(x), ...)
}
\arguments{
\item{x}{The predictor variable.  Missing values are allowed and will be
returned as they were.}

\item{df}{Degrees of freedom of the B-spline basis to be integrated.
One can specify \code{df} rather than \code{knots}, then the function
chooses "df - degree" (minus one if there is an intercept) knots at
suitable quantiles of \code{x} (which will ignore missing values).
The default, \code{NULL}, corresponds to no inner knots, i.e.,
"degree - intercept".}

\item{knots}{The internal breakpoints that define the B-spline basis to be
integrated.  The default is \code{NULL}, which results in a basis for
ordinary polynomial regression.  Typical values are the mean or median
for one knot, quantiles for more knots.  See also \code{Boundary.knots}.}

\item{degree}{Non-negative integer degree of the piecewise polynomial to be
integrated. The default value is 3 for the integral of cubic B-splines.}

\item{intercept}{If \code{TRUE}, an intercept is included in the basis;
Default is \code{FALSE}.}

\item{Boundary.knots}{Boundary points at which to anchor the B-spline basis
to be integrated. By default, they are the range of the non-\code{NA} data.
If both \code{knots} and \code{Boundary.knots} are supplied, the basis
parameters do not depend on \code{x}. Data can extend beyond
\code{Boundary.knots}.}

\item{...}{Optional arguments for future usage.}
}
\value{
A matrix of dimension \code{length(x)} by
\code{df = degree + length(knots)} (plus on if intercept is included).
Attributes that correspond to the arguments specified are returned
for usage for \code{\link{predict.ibs}}. The corresponding B-spline
basis matrix is also returned in attribute named \code{bsMat}.
}
\description{
This function generates the integral of B-spline basis matrix
for a polynomial spline. The arguments are exactly the same with function
\code{\link[splines]{bs}} in package \code{splines}.
}
\details{
It is an implementation of the close form integral of B-spline basis based
on recursion relation.  Internally, it calls \code{\link{bSpline}} and
generates a basis matrix for representing the family of piecewise
polynomials and their corresponding integrals with the specified interior
knots and degree, evaluated at the values of \code{x}.
}
\examples{
x <- seq(0, 1, 0.01)
knots <- c(0.2, 0.4, 0.7, 0.9)
ibsMat <- ibs(x, knots = knots, degree = 1, intercept = TRUE)

## extract original B-spline basis matrix from 'ibs' object
bsMat <- attr(ibsMat, "bsMat")

## plot B-spline basis with their corresponding integrals
library(graphics)
par(mfrow = c(1, 2))
matplot(x, bsMat, type = "l", ylab = "B-spline basis")
abline(v = knots, lty = 2, col = "gray")
matplot(x, ibsMat, type = "l", ylab = "Integral of B-spline basis")
abline(v = knots, lty = 2, col = "gray")
par(mfrow = c(1, 1))
}
\references{
De Boor, Carl. (1978). \emph{A practical guide to splines}.
Vol. 27. New York: Springer-Verlag.
}
\seealso{
\code{\link{bSpline}} for B-spline basis;
\code{\link{mSpline}} for M-spline basis;
\code{\link{iSpline}} for I-spline basis.
\code{\link{cSpline}} for C-spline basis.
}

