% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiro_plot.R
\name{spiro_plot}
\alias{spiro_plot}
\title{Plot data from cardiopulmonary exercise data files}
\usage{
spiro_plot(
  data,
  which = 1:9,
  smooth = "fz",
  base_size = 13,
  grid_args = list(),
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} of the class \code{spiro} containing the gas
exchange data. Usually the output of a \code{\link{spiro}} call.}

\item{which}{A numeric integer setting the plot panels to be displayed. The
panels are numbered in the order of the traditional Wasserman 9-Panel
Plot:
\itemize{
\item 1: VE over time
\item 2: HR and oxygen pulse over time
\item 3: VO2, VCO2 and load over time
\item 4: VE over VCO2
\item 5: V-Slope: HR and VCO2 over VO2
\item 6: EQVO2 and EQVCO2 over time
\item 7: VT over VE
\item 8: RER over time
\item 9: PetO2 and PetCO2 over time
}}

\item{smooth}{Parameter giving the filter methods for smoothing the data.
Default is \code{fz} for a zero phase Butterworth filter. See
\code{\link{spiro_smooth}} for more details and other filter methods (e.g.
time based averages),}

\item{base_size}{An integer controlling the base size of the plots (in pts).}

\item{grid_args}{A list of arguments passed to cowplot::plot_grid() to modify
the arrangement of the plots}

\item{...}{Arguments passed to ggplot2::theme() to modify the appearance of
the plots.}
}
\value{
A ggplot object.
}
\description{
\code{spiro_plot()} returns a \code{ggplot2} graph visualizing
data from cardiopulmonary exercise testing.
}
\details{
This function provides a shortcut for visualizing spiroergometric data from
\code{\link{spiro}} with the help of \code{ggplot2}.
}
\examples{
\donttest{
# Import and process example data
ramp_data <- spiro(
  file = spiro_example("zan_ramp"),
  hr_file = spiro_example("hr_ramp.tcx")
)

# Display the traditional Wasserman 9-Panel Plot
spiro_plot(ramp_data)

# Display selected panels, here V-Slope
spiro_plot(ramp_data, which = 5)

# Modify the arrangement of plots by passing arguments to
# cowplot::plot_grid() via the grid_args argument
spiro_plot(ramp_data, which = c(4, 5, 6, 8), grid_args = list(nrow = 1))

# Modify the appearance of plots by passing arguments to ggplot2::theme() via
# the ... argument
spiro_plot(ramp_data, axis.title.y = ggplot2::element_text(colour = "green"))
}
}
