% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{basis_odp}
\alias{basis_odp}
\title{The basis of Orthogonal Discriminant Projection (ODP)}
\usage{
basis_odp(data, class, d = 2, type = c("proportion", 0.1), ...)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations, coerced to matrix.}

\item{class}{The class for each observation, coerced to a factor.}

\item{d}{Number of dimensions in the projection space.
of \code{class}.}

\item{type}{A vector specifying the neighborhood graph construction.
Expects; \code{c("knn", k)}, \code{c("enn", radius)}, or \code{c("proportion",ratio)}.
Defaults to \code{c("knn", sqrt(nrow(data)))}, nearest neighbors equal to the
square root of observations.}

\item{...}{Optional, other arguments to pass to \code{\link[Rdimtools:do.odp]{Rdimtools::do.odp}}.}
}
\description{
Orthogonal Discriminant Projection (ODP) is a linear dimension reduction
method with class supervision. It maximizes weighted difference between local
and non-local scatter while local information is also preserved by
constructing a neighborhood graph.
}
\examples{
dat  <- scale_sd(wine[, 2:6])
clas <- wine$Type
basis_odp(data = dat, class = clas)
}
\references{
Li B, Wang C, Huang D (2009). "Supervised feature extraction based on
orthogonal discriminant projection." Neurocomputing, 73(1-3), 191-196.
}
\seealso{
\code{\link[Rdimtools:do.odp]{Rdimtools::do.odp}} for locality
preservation arguments.

\code{\link[Rdimtools:aux.graphnbd]{Rdimtools::aux.graphnbd}} for
details on \code{type}.

Other basis producing functions: 
\code{\link{basis_guided}()},
\code{\link{basis_half_circle}()},
\code{\link{basis_olda}()},
\code{\link{basis_onpp}()},
\code{\link{basis_pca}()}
}
\concept{basis producing functions}
