% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{facet_wrap_tour}
\alias{facet_wrap_tour}
\title{Wrap a 1d ribbon of panels into 2d for animation}
\usage{
facet_wrap_tour(facet_var, nrow = NULL, ncol = NULL, dir = "h")
}
\arguments{
\item{facet_var}{Expects a single variable to facet the levels of.
Should be a vector, not a formula (\code{~cyl}) or \code{ggplot2::vars()} call.}

\item{nrow}{Number of rows. Defaults to NULL; set by display dim.}

\item{ncol}{Number of columns. Defaults to NULL; set by display dim.}

\item{dir}{Direction of wrapping: either "h" horizontal by rows,
or "v", for vertical by columns. Defaults to "h".}
}
\description{
Create and wrap a 1d ribbon of panels in 2d.
Because of the side effects of \code{ggtour} and \code{facet_wrap_tour} this wants to be
applied after \code{ggtour} and before any \verb{proto_*} functions.
\code{plotly} may not display well with with faceting.
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins_na.rm[, 1:4])
clas    <- penguins_na.rm$species
bas     <- basis_pca(dat)
mv      <- manip_var_of(bas)
mt_path <- manual_tour(bas, manip_var = mv)

## d = 2 case
message("facet_wrap_tour wants be called early, so that other proto's adopt the facet_var.")
ggt <- ggtour(mt_path, dat, angle = .3) +
  facet_wrap_tour(facet_var = clas, ncol = 2, nrow = 2) +
  proto_default(aes_args = list(color = clas, shape = clas),
                identity_args = list(size = 1.5))
\dontrun{
animate_gganimate(ggt) ## May not always play well with plotly
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_density2d}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_hline0}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
