% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_highlight}
\alias{proto_highlight}
\alias{proto_highlight_2d}
\alias{proto_highlight1d}
\title{Tour proto highlighing specified points}
\usage{
proto_highlight(
  aes_args = list(),
  identity_args = list(color = "red", size = 5, shape = 8),
  row_index = 1,
  mark_initial = FALSE
)

proto_highlight1d(
  aes_args = list(),
  identity_args = list(color = "red", linetype = 2, alpha = 0.9),
  row_index = 1,
  mark_initial = FALSE
)
}
\arguments{
\item{aes_args}{A list of arguments to call inside of aes().
aesthetic mapping of the primary geom. For example,
\code{geom_point(aes(color = my_fct, shape = my_fct))} becomes
\code{aes_args = list(color = my_fct, shape = my_fct)}.}

\item{identity_args}{A list of static, identity arguments passed into
\code{geom_point()}, but outside of \code{aes()}, for instance
\code{geom_point(aes(...), size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.
#' Typically a single numeric for point size, alpha, or similar.}

\item{row_index}{A numeric or logical index of rows to subset to.
Defaults to 1, highlighting the first row.}

\item{mark_initial}{Logical, whether or not to leave a fainter mark at the
subset's initial position. Defaults to FALSE.}
}
\description{
A \code{geom_point} or \code{geom_segment}(1d case) call to draw attention to a subset
of points. This is mostly redundant \code{proto_point} with the implementation
of the \code{row_index} argument on data protos, still helpful in the 1d case and
for \code{mark_initial}, does not use bkg_row_color
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins_na.rm[, 1:4])
clas    <- penguins_na.rm$species
gt_path <- save_history(dat, grand_tour(), max_bases = 5)

## d = 2 case
ggt <- ggtour(gt_path, dat, angle = .3) +
  proto_default(aes_args = list(color = clas, shape = clas)) +
  proto_highlight(row_index = 5)
\dontrun{
animate_plotly(ggt)
}

## Highlight multiple observations
ggt2 <- ggtour(gt_path, dat, angle = .3) +
  proto_default(aes_args = list(color = clas, shape = clas)) +
  proto_highlight(row_index = c( 2, 6, 19),
                  identity_args = list(color = "blue", size = 4, shape = 4))
\dontrun{
animate_plotly(ggt2)
}
## 1D case:
gt_path1d <- save_history(dat, grand_tour(d = 1), max_bases = 3)

ggt <- ggtour(gt_path1d, dat, angle = .3) +
  proto_default1d(aes_args = list(fill = clas, color = clas)) +
  proto_highlight1d(row_index = 7)
\dontrun{
animate_plotly(ggt)
}

## Highlight multiple observations, mark_initial defaults to off
ggt2 <- ggtour(gt_path1d, dat, angle = .3) +
  proto_default1d(aes_args = list(fill = clas, color = clas)) +
  proto_highlight1d(row_index = c(2, 6, 7),
                    identity_args = list(color = "green", linetype = 1))
\dontrun{
animate_plotly(ggt2)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density2d}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_hline0}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
