% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{manip_var_guided}
\alias{manip_var_guided}
\title{The number of the variable that has the max/min absolute norm in final basis.
Useful for setting the manip_var argument.}
\usage{
manip_var_guided(data, index_f = tourr::holes(), p = 2L, rank = 1L, ...)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations.}

\item{index_f}{The index function to optimise.
{tourr} exports holes(), cmass(), and lda_pp(class).}

\item{p}{Number of dimensions in the projection space.}

\item{rank}{The number, specifying the variable with the \code{rank}-th largest
contribution. Defaults to 1.}

\item{...}{Optional, other arguments to pass to \code{tourr::guided_tour}.}
}
\value{
Numeric matrix of the last basis of a guided tour.
}
\description{
The number of the variable that has the max/min absolute norm in final basis.
Useful for setting the manip_var argument.
}
\examples{
manip_var_guided(data = wine[, 2:14], index_f = tourr::holes())

manip_var_guided(data = wine[, 2:14], index_f = tourr::cmass(), rank = 2,
                 alpha = .4, cooling = .9, max.tries = 30)
}
\seealso{
\code{\link[tourr]{guided_tour}} for annealing arguments.
}
