% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{pan_zoom}
\alias{pan_zoom}
\title{Pan (offset) and zoom (scale) a 2 column matrix, dataframe or scaler number.}
\usage{
pan_zoom(x, x_offset = 0L, y_offset = 0L, scale = 1L)
}
\arguments{
\item{x}{Numeric data object with 2 columns (or scaler) to scale and offset.}

\item{x_offset}{Numeric value to pan in the x-direction.}

\item{y_offset}{Numeric value to pan in the x-directionl}

\item{scale}{Numeric value to scale/zoom the size for x.}
}
\value{
Scaled and offset \code{x}. A manual variant of set_axes_position().
}
\description{
Pan (offset) and zoom (scale) a 2 column matrix, dataframe or scaler number.
}
\examples{
ib <- tourr::basis_init(6, 2)
pan_zoom(x = ib, x_offset = -1, y_offset = 0, scale = 2/3)
}
\seealso{
\code{\link{set_axes_position}} for preset choices.
}
