% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Predict_GEE.R
\name{predict.GEE}
\alias{predict.GEE}
\title{predict.GEE}
\usage{
\method{predict}{GEE}(object, ..., newdata)
}
\arguments{
\item{object}{A model object of class \code{GEE} to be used
for making predictions}

\item{...}{Other arguments to be passed to \code{predict}}

\item{newdata}{A data frame containing variables to base the predictions on.}
}
\value{
A vector of predicted values
}
\description{
Model predictions for \code{GEE}
}
\examples{
data(musdata)
coords<-musdata[,4:5]
mgee<-GEE(musculus ~ pollution + exposure,'poisson',musdata,
          coord=coords,corstr="fixed",plot=TRUE)
pred<-predict(mgee,newdata=musdata)

}
\author{
Gudrun Carl,
       Sam Levin
}
