% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diags.R
\name{summarize_top_region}
\alias{summarize_top_region}
\title{Summarize the region in a more human-readable format}
\usage{
summarize_top_region(output_dir, type = "US", vars_to_sum_h, vars_to_sum_p,
  vars_to_sum_env = NULL, samp_size = 10^4, summary_level = 2,
  marginals = NULL)
}
\arguments{
\item{output_dir}{path to top level directory of SPEW folders.  Ex. "./10" for Delaware}

\item{type}{"US" for a US population, "IPUMS" for IPUMS population, or "custom" for a custom population.  This effects what the summary levels are.}

\item{vars_to_sum_h}{character vector of variables from the household data frame output to summarize}

\item{vars_to_sum_p}{character vector of variables from the person data frame output to summarize}

\item{vars_to_sum_env}{character vector of variables from the person data frame which correspond to environment assignments.  Default is NULL.}

\item{samp_size}{number of agents to retain from each lower-level region, for plotting purposes only.  Default is 10^4.}

\item{summary_level}{For the US, 1-state, 2-county, 3-tract.  For IPUMS, 1 -country, 2-province.  For "custom," these are defined by the user's input data.}

\item{marginals}{list containing all of the marginal totals.  See ?make_ipf_marg for more details.}
}
\value{
list with the household summary list, people summary list, header for households, and header for people, and a data frame of plotting coordinates by summary region
}
\description{
Summarize the region in a more human-readable format
}
\note{
This function is only guaranteed to work when you provide marginals describing how a category is "cut."  If a certain category is not represented, then the final totals in each category may be off.
}
