/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaDefaultInputMap;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.WrappedSyntaxView;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class RSyntaxTextAreaUI
extends RTextAreaUI {
    private static final String SHARED_ACTION_MAP_NAME = "RSyntaxTextAreaUI.actionMap";
    private static final String SHARED_INPUT_MAP_NAME = "RSyntaxTextAreaUI.inputMap";
    private static final EditorKit defaultKit = new RSyntaxTextAreaEditorKit();

    public static ComponentUI createUI(JComponent jComponent) {
        return new RSyntaxTextAreaUI(jComponent);
    }

    public RSyntaxTextAreaUI(JComponent jComponent) {
        super(jComponent);
    }

    public View create(Element element) {
        RTextArea rTextArea = this.getRTextArea();
        if (rTextArea instanceof RSyntaxTextArea) {
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
            View view = rSyntaxTextArea.getLineWrap() ? new WrappedSyntaxView(element) : new SyntaxView(element);
            return view;
        }
        return null;
    }

    protected Highlighter createHighlighter() {
        return new RSyntaxTextAreaHighlighter();
    }

    protected String getActionMapName() {
        return SHARED_ACTION_MAP_NAME;
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    protected InputMap getRTextAreaInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)UIManager.get(SHARED_INPUT_MAP_NAME);
        if (inputMap == null) {
            inputMap = new RSyntaxTextAreaDefaultInputMap();
            UIManager.put(SHARED_INPUT_MAP_NAME, inputMap);
        }
        inputMapUIResource.setParent(inputMap);
        return inputMapUIResource;
    }

    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        this.paintMatchedBracket(graphics);
    }

    protected void paintMatchedBracket(Graphics graphics) {
        Rectangle rectangle;
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        if (rSyntaxTextArea.isBracketMatchingEnabled() && (rectangle = rSyntaxTextArea.match) != null) {
            if (rSyntaxTextArea.getAnimateBracketMatching()) {
                graphics.setColor(rSyntaxTextArea.getMatchedBracketBGColor());
                graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1, 5, 5);
                graphics.setColor(rSyntaxTextArea.getMatchedBracketBorderColor());
                graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1, 5, 5);
            } else {
                graphics.setColor(rSyntaxTextArea.getMatchedBracketBGColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
                graphics.setColor(rSyntaxTextArea.getMatchedBracketBorderColor());
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1);
            }
        }
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("RSTA.syntaxScheme")) {
            this.modelChanged();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    public void refreshSyntaxHighlighting() {
        this.modelChanged();
    }

    public int yForLineContaining(int n) throws BadLocationException {
        Rectangle rectangle = this.getVisibleEditorRect();
        if (rectangle != null) {
            RSTAView rSTAView = (RSTAView)((Object)this.getRootView(this.textArea).getView(0));
            return rSTAView.yForLineContaining(rectangle, n);
        }
        return -1;
    }
}

