/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.AbstractDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class BasicStationTitle
extends AbstractDockTitle {
    private int preferredDimension = 20;
    private TitleColor activeColor = new BasicStationTitleColor("title.station.active", Color.WHITE);
    private TitleColor activeTextColor = new BasicStationTitleColor("title.station.active.text", Color.BLACK);
    private TitleColor inactiveColor = new BasicStationTitleColor("title.station.inactive", Color.WHITE);
    private TitleColor inactiveTextColor = new BasicStationTitleColor("title.station.inactive.text", Color.DARK_GRAY);

    public BasicStationTitle(Dockable dockable, DockTitleVersion origin) {
        super(dockable, origin);
        this.setBorder("dock.border.title.station.basic", BorderFactory.createBevelBorder(0));
        this.setActive(false);
        this.addColor(this.activeColor);
        this.addColor(this.activeTextColor);
        this.addColor(this.inactiveColor);
        this.addColor(this.inactiveTextColor);
    }

    protected void paintBackground(Graphics g, JComponent component) {
        Color background = component.getBackground();
        Insets insets = component.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = component.getWidth() - insets.left - insets.right;
        int height = component.getHeight() - insets.top - insets.bottom;
        g.setColor(background);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Color bright = Colors.brighter(background, 0.1);
        Color dark = Colors.darker(background, 0.1);
        if (width > height) {
            if (height >= 6) {
                for (int i = 0; i < 3; ++i) {
                    this.drawLineHorizontal(g, x, height * (i + 1) / 4, width, bright, dark);
                }
            } else if (height >= 4) {
                this.drawLineHorizontal(g, x, y, width, bright, dark);
                this.drawLineHorizontal(g, x, y + height - 2, width, bright, dark);
            } else if (height >= 2) {
                this.drawLineHorizontal(g, x, y, width, bright, dark);
            }
        } else if (width >= 6) {
            for (int i = 0; i < 3; ++i) {
                this.drawLineVertical(g, width * (i + 1) / 4, y, height, bright, dark);
            }
        } else if (width >= 4) {
            this.drawLineVertical(g, x, y, height, bright, dark);
            this.drawLineVertical(g, x + width - 2, y, height, bright, dark);
        } else if (width >= 2) {
            this.drawLineVertical(g, x, y, height, bright, dark);
        }
    }

    public int getPreferredDimension() {
        return this.preferredDimension;
    }

    public void setPreferredDimension(int preferredDimension) {
        this.preferredDimension = preferredDimension;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        this.updateColors();
    }

    protected void updateColors() {
        if (this.isActive()) {
            if (this.activeTextColor != null && this.activeColor != null) {
                this.setBackground(this.activeColor.color());
                this.setForeground(this.activeTextColor.color());
            }
        } else if (this.inactiveColor != null && this.inactiveTextColor != null) {
            this.setBackground(this.inactiveColor.color());
            this.setForeground(this.inactiveTextColor.color());
        }
        this.repaint();
    }

    public Color getActiveColor() {
        return (Color)this.activeColor.value();
    }

    public Color getInactiveColor() {
        return (Color)this.inactiveColor.value();
    }

    public Color getActiveTextColor() {
        return (Color)this.activeTextColor.value();
    }

    public Color getInactiveTextColor() {
        return (Color)this.inactiveTextColor.value();
    }

    public void setActiveColor(Color activeColor) {
        this.activeColor.setValue(activeColor);
        this.updateColors();
    }

    public void setActiveTextColor(Color activeTextColor) {
        this.activeTextColor.setValue(activeTextColor);
        this.updateColors();
    }

    public void setInactiveColor(Color inactiveColor) {
        this.inactiveColor.setValue(inactiveColor);
        this.updateColors();
    }

    public void setInactiveTextColor(Color inactiveTextColor) {
        this.inactiveTextColor.setValue(inactiveTextColor);
        this.updateColors();
    }

    public TitleColor getActiveTitleColor() {
        return this.activeColor;
    }

    public TitleColor getActiveTextTitleColor() {
        return this.activeTextColor;
    }

    public TitleColor getInactiveTitleColor() {
        return this.inactiveColor;
    }

    public TitleColor getInactiveTextTitleColor() {
        return this.inactiveTextColor;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(this.preferredDimension, size.width), Math.max(this.preferredDimension, size.height));
    }

    private void drawLineHorizontal(Graphics g, int x, int y, int width, Color up, Color down) {
        g.setColor(up);
        g.drawLine(x + 2, y, x + width - 4, y);
        g.setColor(down);
        g.drawLine(x + 2, y + 1, x + width - 4, y + 1);
    }

    private void drawLineVertical(Graphics g, int x, int y, int height, Color up, Color down) {
        g.setColor(up);
        g.drawLine(x, y + 2, x, y + height - 4);
        g.setColor(down);
        g.drawLine(x + 1, y + 2, x + 1, y + height - 4);
    }

    private class BasicStationTitleColor
    extends TitleColor {
        public BasicStationTitleColor(String id, Color backup) {
            super(id, BasicStationTitle.this, backup);
        }

        protected void changed(Color oldValue, Color newValue) {
            BasicStationTitle.this.updateColors();
        }
    }
}

