/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color removeAlpha(Color color) {
        return ColorUtil.setAlpha(color, 255);
    }

    public static Color setAlpha(Color color, int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("invalid alpha value");
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color setSaturation(Color color, float saturation) {
        if (saturation < 0.0f || saturation > 1.0f) {
            throw new IllegalArgumentException("invalid saturation value");
        }
        int alpha = color.getAlpha();
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color c = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        return ColorUtil.setAlpha(c, alpha);
    }

    public static Color setBrightness(Color color, float brightness) {
        if (brightness < 0.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("invalid brightness value");
        }
        int alpha = color.getAlpha();
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color c = Color.getHSBColor(hsb[0], hsb[1], brightness);
        return ColorUtil.setAlpha(c, alpha);
    }

    public static String toHexString(Color color) {
        return "#" + Integer.toHexString(color.getRGB() | 0xFF000000).substring(2);
    }

    public static Color computeForeground(Color bg) {
        float[] rgb = bg.getRGBColorComponents(null);
        float y = 0.3f * rgb[0] + 0.59f * rgb[1] + 0.11f * rgb[2];
        return y > 0.5f ? Color.BLACK : Color.WHITE;
    }

    public static Color blend(Color origin, Color over) {
        if (over == null) {
            return origin;
        }
        if (origin == null) {
            return over;
        }
        int a = over.getAlpha();
        int rb = (over.getRGB() & 0xFF00FF) * (a + 1) + (origin.getRGB() & 0xFF00FF) * (255 - a) & 0xFF00FF00;
        int g = (over.getRGB() & 0xFF00) * (a + 1) + (origin.getRGB() & 0xFF00) * (255 - a) & 0xFF0000;
        return new Color(over.getRGB() & 0xFF000000 | (rb | g) >> 8);
    }

    public static Color interpolate(Color b, Color a, float t) {
        float[] acomp = a.getRGBComponents(null);
        float[] bcomp = b.getRGBComponents(null);
        float[] ccomp = new float[4];
        for (int i = 0; i < 4; ++i) {
            ccomp[i] = acomp[i] + (bcomp[i] - acomp[i]) * t;
        }
        return new Color(ccomp[0], ccomp[1], ccomp[2], ccomp[3]);
    }

    public static Paint getCheckerPaint() {
        return ColorUtil.getCheckerPaint(Color.WHITE, Color.GRAY, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Paint getCheckerPaint(Color c1, Color c2, int size) {
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics g = img.getGraphics();
        try {
            g.setColor(c1);
            g.fillRect(0, 0, size, size);
            g.setColor(c2);
            g.fillRect(0, 0, size / 2, size / 2);
            g.fillRect(size / 2, size / 2, size / 2, size / 2);
        }
        finally {
            g.dispose();
        }
        return new TexturePaint(img, new Rectangle(0, 0, size, size));
    }

    public static void tileStretchPaint(Graphics g, JComponent comp, BufferedImage img, Insets ins) {
        int left = ins.left;
        int right = ins.right;
        int top = ins.top;
        int bottom = ins.bottom;
        g.drawImage(img, 0, 0, left, top, 0, 0, left, top, null);
        g.drawImage(img, left, 0, comp.getWidth() - right, top, left, 0, img.getWidth() - right, top, null);
        g.drawImage(img, comp.getWidth() - right, 0, comp.getWidth(), top, img.getWidth() - right, 0, img.getWidth(), top, null);
        g.drawImage(img, 0, top, left, comp.getHeight() - bottom, 0, top, left, img.getHeight() - bottom, null);
        g.drawImage(img, left, top, comp.getWidth() - right, comp.getHeight() - bottom, left, top, img.getWidth() - right, img.getHeight() - bottom, null);
        g.drawImage(img, comp.getWidth() - right, top, comp.getWidth(), comp.getHeight() - bottom, img.getWidth() - right, top, img.getWidth(), img.getHeight() - bottom, null);
        g.drawImage(img, 0, comp.getHeight() - bottom, left, comp.getHeight(), 0, img.getHeight() - bottom, left, img.getHeight(), null);
        g.drawImage(img, left, comp.getHeight() - bottom, comp.getWidth() - right, comp.getHeight(), left, img.getHeight() - bottom, img.getWidth() - right, img.getHeight(), null);
        g.drawImage(img, comp.getWidth() - right, comp.getHeight() - bottom, comp.getWidth(), comp.getHeight(), img.getWidth() - right, img.getHeight() - bottom, img.getWidth(), img.getHeight(), null);
    }
}

