/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.office.OdfOfficeChart;

public class OdfChartDocument
extends OdfDocument {
    private static String EMPTY_CHART_DOCUMENT_PATH = "/OdfChartDocument.odc";
    private static OdfDocument.Resource EMPTY_CHART_DOCUMENT_RESOURCE = new OdfDocument.Resource(EMPTY_CHART_DOCUMENT_PATH);

    public static OdfChartDocument newChartDocument() throws Exception {
        return (OdfChartDocument)OdfDocument.loadTemplate(EMPTY_CHART_DOCUMENT_RESOURCE);
    }

    public static OdfChartDocument newChartTemplateDocument() throws Exception {
        OdfChartDocument doc = (OdfChartDocument)OdfDocument.loadTemplate(EMPTY_CHART_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.CHART_TEMPLATE);
        return doc;
    }

    protected OdfChartDocument() {
    }

    public OdfOfficeChart getContentRoot() throws Exception {
        return super.getContentRoot(OdfOfficeChart.class);
    }

    public void changeMode(OdfMediaType type) {
        this.setMediaType(type.getOdfMediaType());
        this.getPackage().setMediaType(type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType {
        CHART(OdfDocument.OdfMediaType.CHART),
        CHART_TEMPLATE(OdfDocument.OdfMediaType.CHART_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String toString() {
            return this.mMediaType.toString();
        }

        public OdfDocument.OdfMediaType getOdfMediaType() {
            return this.mMediaType;
        }

        public String getName() {
            return this.mMediaType.getName();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

