/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.DockUI;
import bibliothek.gui.dock.common.theme.ThemeMap;
import bibliothek.gui.dock.common.theme.ThemeMapListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemeMeta;
import bibliothek.gui.dock.themes.ThemeMetaListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JRadioButtonMenuItem;

public class ThemeMenuPiece
extends BaseMenuPiece {
    private DockController controller;
    private List<Item> items = new ArrayList<Item>();
    private ThemeMap themes;
    private boolean transferTheme = true;
    private ThemeMapListener listener = new ThemeMapListener(){

        public void changed(ThemeMap map, int index, String key, ThemeFactory oldFactory, ThemeFactory newFactory) {
            if (oldFactory != null) {
                ThemeMenuPiece.this.items.remove(index);
                ThemeMenuPiece.this.remove(index);
            }
            if (newFactory != null) {
                Item item = new Item(key, newFactory);
                ThemeMenuPiece.this.items.add(index, item);
                ThemeMenuPiece.this.insert(index, item);
            }
        }

        public void selectionChanged(ThemeMap map, String oldKey, String newKey) {
            ThemeFactory factory;
            for (Item item : ThemeMenuPiece.this.items) {
                item.setSelected(item.getKey().equals(newKey));
            }
            if (ThemeMenuPiece.this.controller != null && ThemeMenuPiece.this.transferTheme && (factory = ThemeMenuPiece.this.themes.getSelectedFactory()) != null) {
                ThemeMenuPiece.this.controller.setTheme(factory.create(ThemeMenuPiece.this.controller));
            }
        }
    };

    public ThemeMenuPiece(DockController controller, boolean defaultThemes) {
        this.setController(controller);
        this.setTransferTheme(true);
        ThemeMap themes = new ThemeMap();
        if (defaultThemes) {
            DockUI ui = DockUI.getDefaultDockUI();
            int index = 0;
            for (ThemeFactory theme : ui.getThemes()) {
                themes.add(String.valueOf(index++), theme);
            }
            themes.select(ui.getDefaultTheme());
        }
        this.setThemes(themes);
    }

    public ThemeMenuPiece(DockController controller, ThemeMap map) {
        this.setTransferTheme(false);
        this.setController(controller);
        this.setThemes(map);
    }

    public void setTransferTheme(boolean transferTheme) {
        this.transferTheme = transferTheme;
    }

    public boolean isTransferTheme() {
        return this.transferTheme;
    }

    public void destroy() {
        this.setThemes(null);
        this.setController(null);
    }

    public void setThemes(ThemeMap themes) {
        if (this.themes != themes) {
            if (this.isBound()) {
                this.uninstall();
            }
            this.themes = themes;
            if (this.isBound()) {
                this.install();
            }
        }
    }

    public void bind() {
        if (!this.isBound()) {
            super.bind();
            this.install();
        }
    }

    public void unbind() {
        if (this.isBound()) {
            super.unbind();
            this.uninstall();
        }
    }

    private void install() {
        if (this.themes != null) {
            ThemeFactory factory;
            this.themes.addThemeMapListener(this.listener);
            String selected = this.themes.getSelectedKey();
            int n = this.themes.size();
            for (int i = 0; i < n; ++i) {
                Item item = new Item(this.themes.getKey(i), this.themes.getFactory(i));
                this.items.add(item);
                this.add(item);
                item.setSelected(item.getKey().equals(selected));
            }
            if (this.transferTheme && this.controller != null && (factory = this.themes.getSelectedFactory()) != null) {
                this.controller.setTheme(factory.create(this.controller));
            }
        }
    }

    private void uninstall() {
        if (this.themes != null) {
            this.themes.removeThemeMapListener(this.listener);
            this.removeAll();
            this.items.clear();
        }
    }

    public ThemeMap getThemes() {
        return this.themes;
    }

    public DockController getController() {
        return this.controller;
    }

    public void setController(DockController controller) {
        ThemeFactory selection;
        this.controller = controller;
        if (controller != null && this.themes != null && this.transferTheme && (selection = this.themes.getSelectedFactory()) != null) {
            controller.setTheme(selection.create(controller));
        }
        for (Item item : this.items) {
            item.setController(controller);
        }
    }

    private class Item
    extends JRadioButtonMenuItem
    implements ActionListener,
    ThemeMetaListener {
        private String key;
        private ThemeFactory factory;
        private ThemeMeta meta;

        public Item(String key, ThemeFactory factory) {
            this.key = key;
            this.factory = factory;
            this.addActionListener(this);
            this.setController(ThemeMenuPiece.this.getController());
        }

        public void setController(DockController controller) {
            if (this.meta != null) {
                this.meta.removeListener((ThemeMetaListener)this);
                this.setText("");
                this.setToolTipText("");
                this.meta = null;
            }
            if (controller != null) {
                this.meta = this.factory.createMeta(controller);
                this.meta.addListener((ThemeMetaListener)this);
                this.setText(this.meta.getName());
                this.setToolTipText(this.meta.getDescription());
            }
        }

        public void actionPerformed(ActionEvent e) {
            ThemeMenuPiece.this.themes.select(this.key);
        }

        public void authorsChanged(ThemeMeta meta) {
        }

        public void descriptionChanged(ThemeMeta meta) {
            this.setToolTipText(meta.getDescription());
        }

        public void nameChanged(ThemeMeta meta) {
            this.setText(meta.getName());
        }

        public void webpagesChanged(ThemeMeta meta) {
        }

        public String getKey() {
            return this.key;
        }
    }
}

