/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiUIBridge<V, U extends UIValue<V>>
implements UIBridge<V, U> {
    private Map<String, UIBridge<V, U>> bridges = new HashMap<String, UIBridge<V, U>>();
    private Map<String, List<U>> values = new HashMap<String, List<U>>();
    private UIProperties<V, U, ?> manager;

    public MultiUIBridge(UIProperties<V, U, ?> manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Manager must not be null");
        }
        this.manager = manager;
    }

    public void put(String id, UIBridge<V, U> bridge) {
        block6: {
            List<U> list;
            UIBridge<V, UIValue> old = bridge == null ? this.bridges.remove(id) : this.bridges.put(id, bridge);
            if (old == null && bridge == null || (list = this.values.get(id)) == null) break block6;
            if (old != null) {
                for (UIValue color : list) {
                    old.remove(id, color);
                }
            }
            V original = this.manager.get(id);
            if (bridge != null) {
                for (UIValue color : list) {
                    bridge.add(id, color);
                    bridge.set(id, original, color);
                }
            } else {
                for (UIValue color : list) {
                    color.set(original);
                }
            }
        }
    }

    public UIBridge<V, U> getBridge(String id) {
        return this.bridges.get(id);
    }

    @Override
    public void add(String id, U uiValue) {
        List<U> list;
        UIBridge<V, U> provider = this.bridges.get(id);
        if (provider != null) {
            provider.add(id, uiValue);
        }
        if ((list = this.values.get(id)) == null) {
            list = new LinkedList<U>();
            this.values.put(id, list);
        }
        list.add(uiValue);
    }

    @Override
    public void remove(String id, U uiValue) {
        List<U> list;
        UIBridge<V, U> provider = this.bridges.get(id);
        if (provider != null) {
            provider.remove(id, uiValue);
        }
        if ((list = this.values.get(id)) != null) {
            list.remove(uiValue);
            if (list.isEmpty()) {
                this.values.remove(id);
            }
        }
    }

    @Override
    public void set(String id, V value, U uiValue) {
        UIBridge<V, U> bridge = this.bridges.get(id);
        if (bridge != null) {
            bridge.set(id, value, uiValue);
        } else {
            uiValue.set(value);
        }
    }
}

