/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.location.CMaximizedLocation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CNormalModeArea;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.event.DockRelocatorAdapter;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSplitDockStationHandle {
    private CStation<SplitDockStation> station;
    private Normal normal = new Normal();
    private Maximal maximal = new Maximal();
    private LocationMode normalMode;
    private MaximizedMode<?> maximizedMode;
    private CLocationModeManager manager;
    private List<ModeAreaListenerWrapper> listeners = new ArrayList<ModeAreaListenerWrapper>();
    private SplitDockListener fullScreenListener = new SplitDockListener(){

        public void fullScreenDockableChanged(SplitDockStation station, Dockable oldFullScreen, Dockable newFullScreen) {
            ModeAreaListenerWrapper[] array;
            HashSet<Dockable> affected = new HashSet<Dockable>();
            if (oldFullScreen != null) {
                affected.add(oldFullScreen);
            }
            if (newFullScreen != null) {
                affected.add(newFullScreen);
            }
            for (ModeAreaListenerWrapper listener : array = CSplitDockStationHandle.this.listeners.toArray(new ModeAreaListenerWrapper[CSplitDockStationHandle.this.listeners.size()])) {
                listener.fire(affected);
            }
        }
    };
    private DockRelocatorListener relocatorListener = new DockRelocatorAdapter(){

        public void drop(DockController controller, Dockable dockable, DockStation station) {
            MaximizedModeArea next = CSplitDockStationHandle.this.maximizedMode.getNextMaximizeArea(station);
            if (next == CSplitDockStationHandle.this.maximal) {
                CSplitDockStationHandle.this.manager.runTransaction(new AffectingRunnable(){

                    public void run(AffectedSet set) {
                        CSplitDockStationHandle.this.maximizedMode.unmaximize(CSplitDockStationHandle.this.getStation(), set);
                    }
                });
            }
        }
    };

    public CSplitDockStationHandle(CStation<SplitDockStation> station, CLocationModeManager manager) {
        this.station = station;
        this.manager = manager;
    }

    private void add(ModeAreaListenerWrapper listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be empty");
        }
        if (this.listeners.isEmpty()) {
            this.station.getStation().addSplitDockStationListener(this.fullScreenListener);
        }
        this.listeners.add(listener);
    }

    private void remove(ModeAreaListenerWrapper listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.station.getStation().removeSplitDockStationListener(this.fullScreenListener);
        }
    }

    public SplitDockStation getStation() {
        return this.station.getStation();
    }

    public CNormalModeArea asNormalModeArea() {
        return this.normal;
    }

    public CMaximizedModeArea asMaximziedModeArea() {
        return this.maximal;
    }

    public void dropAside(Dockable dockable) {
        if (dockable.getDockParent() == this.station.getStation()) {
            throw new IllegalStateException("dockable already a child");
        }
        DockableSplitDockTree tree = this.getStation().createTree();
        if (tree.getRoot() == null) {
            tree.root(dockable);
        } else {
            tree.root(tree.horizontal(tree.put(dockable), tree.unroot()));
        }
        this.getStation().dropTree(tree, false);
    }

    protected class Maximal
    implements CMaximizedModeArea {
        private DockController controller;

        protected Maximal() {
        }

        public void addModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, listener));
        }

        public void removeModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, listener));
        }

        public void setMode(LocationMode mode) {
            if (CSplitDockStationHandle.this.maximizedMode != null && mode != null) {
                throw new IllegalStateException("handle already in use");
            }
            CSplitDockStationHandle.this.maximizedMode = (MaximizedMode)mode;
        }

        public void setController(DockController controller) {
            if (this.controller != null) {
                this.controller.getRelocator().removeDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
            this.controller = controller;
            if (controller != null) {
                controller.getRelocator().addDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public LocationMode getUnmaximizedMode() {
            return CSplitDockStationHandle.this.normalMode;
        }

        public void prepareApply(Dockable dockable, AffectedSet affected) {
            CLocationMode normal = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(NormalMode.IDENTIFIER);
            if (normal != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, normal, affected, false);
            }
        }

        public void prepareApply(Dockable dockable, Location history, AffectedSet set) {
            CGroupMovement movement;
            CLocationMode normal;
            boolean remaximize;
            boolean bl = remaximize = history != null && history.getLocation() instanceof SplitDockFullScreenProperty;
            if (!remaximize && CSplitDockStationHandle.this.manager.getMode(dockable) != ExtendedMode.NORMALIZED && (normal = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(NormalMode.IDENTIFIER)) != null && (movement = CSplitDockStationHandle.this.maximizedMode.getManager().getGroupBehavior().prepare(CSplitDockStationHandle.this.manager, dockable, normal.getExtendedMode())) != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, normal.getExtendedMode(), movement);
            }
        }

        public Runnable onApply(LocationModeEvent event) {
            MaximizedModeArea area;
            DockableProperty property;
            if (event.isDone()) {
                return null;
            }
            Location location = event.getLocation();
            Dockable dockable = event.getDockable();
            DockableProperty dockableProperty = property = location == null ? null : location.getLocation();
            if (event.getMode().getUniqueIdentifier().equals(NormalMode.IDENTIFIER) && property != null && property.getSuccessor() == null) {
                MaximizedModeArea area2;
                CLocationMode last = (CLocationMode)CSplitDockStationHandle.this.manager.getCurrentMode(dockable);
                CLocationMode secondLast = (CLocationMode)CSplitDockStationHandle.this.manager.getPreviousMode(dockable);
                if (last != null && secondLast != null && NormalMode.IDENTIFIER.equals(secondLast.getUniqueIdentifier()) && MaximizedMode.IDENTIFIER.equals(last.getUniqueIdentifier()) && (area2 = (MaximizedModeArea)CSplitDockStationHandle.this.maximizedMode.get(location.getRoot())) == this) {
                    area2.setMaximized(dockable, false, null, event.getAffected());
                    event.done();
                    return null;
                }
            }
            if (location != null && this.getMaximized() != null) {
                Map<ExtendedMode, DockStation> roots = CSplitDockStationHandle.this.manager.getRepresentations(location.getRoot());
                for (DockStation station : roots.values()) {
                    if (!DockUtilities.isAncestor(this.getStation(), station)) continue;
                    CSplitDockStationHandle.this.maximizedMode.unmaximize(this, event.getAffected());
                    break;
                }
            }
            if (CSplitDockStationHandle.this.maximizedMode != null && event.getMode().getUniqueIdentifier().equals(NormalMode.IDENTIFIER) && (area = CSplitDockStationHandle.this.maximizedMode.getMaximizeArea(dockable)) == this) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(dockable, event.getAffected());
            }
            return null;
        }

        public Runnable onApply(final LocationModeEvent event, final Dockable replacement) {
            if (event.isDone()) {
                return null;
            }
            if (!event.getMode().getUniqueIdentifier().equals(NormalMode.IDENTIFIER)) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(this.getStation().getFullScreen(), event.getAffected());
                return new Runnable(){

                    public void run() {
                        if (replacement != null && replacement.getDockParent() != null) {
                            CSplitDockStationHandle.this.maximizedMode.maximize(Maximal.this, replacement, event.getAffected());
                        }
                    }
                };
            }
            return null;
        }

        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return this.getStation().getFullScreen() == dockable;
        }

        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        public boolean respectWorkingAreas() {
            return false;
        }

        public Dockable[] getMaximized() {
            Dockable dockable = this.getStation().getFullScreen();
            if (dockable == null) {
                return null;
            }
            return new Dockable[]{dockable};
        }

        public void setMaximized(Dockable dockable, boolean maximized, Location location, AffectedSet set) {
            SplitDockStation station = this.getStation();
            if (!maximized) {
                if (station.getFullScreen() != null && DockUtilities.isAncestor(station.getFullScreen(), dockable)) {
                    station.setFullScreen(null);
                }
            } else {
                DockableProperty property;
                DockableProperty dockableProperty = property = location == null ? null : location.getLocation();
                if (property instanceof SplitDockFullScreenProperty && this.getMaximized() != null && this.getStation().drop(dockable, property)) {
                    return;
                }
                if (dockable.getDockParent() == station) {
                    station.setFullScreen(dockable);
                } else {
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                    CSplitDockStationHandle.this.dropAside(dockable);
                    station.setFullScreen(dockable);
                }
            }
            set.add(dockable);
        }

        public boolean isRepresenting(DockStation station) {
            return station == CSplitDockStationHandle.this.station.getStation();
        }

        public CLocation getCLocation(Dockable dockable) {
            CLocation stationLocation = CSplitDockStationHandle.this.station.getStationLocation();
            DockableProperty property = DockUtilities.getPropertyChain(this.getStation(), dockable);
            if (property != null) {
                property = property.getSuccessor();
            }
            CMaximizedLocation result = new CMaximizedLocation(stationLocation.findRoot());
            if (property != null) {
                return result.expandProperty(property);
            }
            return result;
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            return this.getCLocation(dockable);
        }
    }

    protected class Normal
    implements CNormalModeArea {
        protected Normal() {
        }

        public void setMode(LocationMode mode) {
            CSplitDockStationHandle.this.normalMode = mode;
        }

        public void addModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, listener));
        }

        public void removeModeAreaListener(ModeAreaListener listener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, listener));
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public void setController(DockController controller) {
        }

        public boolean isNormalModeChild(Dockable dockable) {
            return this.isChild(dockable) && this.getStation().getFullScreen() != dockable;
        }

        public DockableProperty getLocation(Dockable child) {
            return DockUtilities.getPropertyChain(this.getStation(), child);
        }

        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return dockable.getDockParent() == this.getStation() && !CSplitDockStationHandle.this.maximal.isChild(dockable);
        }

        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        public boolean respectWorkingAreas() {
            return true;
        }

        public void setLocation(Dockable dockable, DockableProperty location, AffectedSet set) {
            Dockable fullscreen = this.getStation().getFullScreen();
            if (fullscreen != null) {
                CSplitDockStationHandle.this.maximal.setMaximized(fullscreen, false, null, set);
            }
            set.add(dockable);
            if (dockable.getDockParent() == CSplitDockStationHandle.this.station.getStation()) {
                if (location != null) {
                    this.getStation().move(dockable, location);
                }
            } else {
                if (location != null && !this.getStation().drop(dockable, location)) {
                    location = null;
                }
                if (location == null && !DockUtilities.isAncestor(CSplitDockStationHandle.this.station.getStation(), dockable) && this.getStation().accept(dockable) && dockable.accept(this.getStation()) && CSplitDockStationHandle.this.manager.getController().getAcceptance().accept(this.getStation(), dockable)) {
                    this.getStation().drop(dockable);
                }
            }
        }

        public CLocation getCLocation(Dockable dockable) {
            DockableProperty property = DockUtilities.getPropertyChain(this.getStation(), dockable);
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(property);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            DockableProperty property = location.getLocation();
            if (property == null) {
                return CSplitDockStationHandle.this.station.getStationLocation();
            }
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(property);
        }

        public CLocation getBaseLocation() {
            return CSplitDockStationHandle.this.station.getStationLocation();
        }

        public boolean isWorkingArea() {
            return CSplitDockStationHandle.this.station.isWorkingArea();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModeAreaListenerWrapper {
        private ModeAreaListener listener;
        private ModeArea area;

        public ModeAreaListenerWrapper(ModeArea area, ModeAreaListener listener) {
            this.area = area;
            this.listener = listener;
        }

        public void fire(Set<Dockable> dockables) {
            this.listener.internalLocationChange(this.area, dockables);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ModeAreaListenerWrapper) {
                ModeAreaListenerWrapper other = (ModeAreaListenerWrapper)obj;
                return other.area.equals(this.area) && other.listener.equals(this.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.area.hashCode() ^ this.listener.hashCode();
        }
    }
}

