/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import java.util.ArrayList;
import java.util.Arrays;

public final class Path {
    public static final Path TYPE_INT_PATH = new Path("java.lang.Integer");
    public static final Path TYPE_STRING_PATH = new Path("java.lang.String");
    public static final Path TYPE_BOOLEAN_PATH = new Path("java.lang.Boolean");
    public static final Path TYPE_KEYSTROKE_PATH = new Path("javax.swing.KeyStroke");
    public static final Path TYPE_MODIFIER_MASK_PATH = new Path("dock.modifier_mask");
    public static final Path TYPE_STRING_CHOICE_PATH = new Path("dock.choice");
    public static final Path TYPE_LABEL = new Path("dock.label");
    private String[] segments;

    public static String encodeSegment(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            if (c == '.') {
                bl = true;
            } else if (c == '\\') {
                bl = true;
            } else if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) {
                    bl = true;
                }
            } else if (!Character.isJavaIdentifierPart(c)) {
                bl = true;
            }
            if (bl) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String decodeSegment(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                bl = false;
                stringBuilder.append(c);
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidPath(String string) {
        try {
            new Path(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public Path(String ... stringArray) {
        this.segments = stringArray;
    }

    public Path() {
        this.segments = new String[0];
    }

    public Path(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        boolean bl = false;
        int n2 = string.length();
        for (int i = 0; i <= n2; ++i) {
            char c;
            if (i == n2) {
                bl = false;
                c = '.';
            } else {
                c = string.charAt(i);
            }
            if (bl) {
                bl = false;
                continue;
            }
            if (c == '.') {
                if (n + 1 == i) {
                    throw new IllegalArgumentException("not a path: empty segment");
                }
                arrayList.add(Path.decodeSegment(string.substring(n + 1, i)));
                n = i;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (n + 1 == i) {
                if (Character.isJavaIdentifierStart(c)) continue;
                throw new IllegalArgumentException("not a valid start of a segment: '" + c + "'");
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("not a valid character of a segment: '" + c + "'");
        }
        this.segments = arrayList.toArray(new String[arrayList.size()]);
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int n) {
        return this.segments[n];
    }

    public String getLastSegment() {
        if (this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public Path subPath(int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("length must be at least 1: " + n2);
        }
        String[] stringArray = new String[n2];
        System.arraycopy(this.segments, n, stringArray, 0, n2);
        return new Path(stringArray);
    }

    public Path append(Path path) {
        String[] stringArray = new String[this.segments.length + path.segments.length];
        System.arraycopy(this.segments, 0, stringArray, 0, this.segments.length);
        System.arraycopy(path.segments, 0, stringArray, this.segments.length, path.segments.length);
        return new Path(stringArray);
    }

    public Path uniqueAppend(Path path) {
        String[] stringArray = new String[this.segments.length + 2 + path.segments.length];
        stringArray[0] = "_f" + this.segments.length;
        System.arraycopy(this.segments, 0, stringArray, 1, this.segments.length);
        stringArray[this.segments.length + 1] = "_s" + path.segments.length;
        System.arraycopy(path.segments, 0, stringArray, this.segments.length + 2, path.segments.length);
        return new Path(stringArray);
    }

    public Path append(String string) {
        return this.append(new Path(string));
    }

    public Path getParent() {
        if (this.segments.length == 0) {
            return null;
        }
        String[] stringArray = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, stringArray, 0, stringArray.length);
        return new Path(stringArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Path path = (Path)object;
        return Arrays.equals(this.segments, path.segments);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.segments.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(Path.encodeSegment(this.segments[i]));
        }
        return stringBuilder.toString();
    }
}

