/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockPropertyListener;
import bibliothek.gui.dock.util.PropertyKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyValue<A> {
    private PropertyKey<A> key;
    private DockProperties properties;
    private A value;
    private DockPropertyListener<A> listener;

    public PropertyValue(PropertyKey<A> propertyKey) {
        this(propertyKey, null);
    }

    public PropertyValue(PropertyKey<A> propertyKey, DockController dockController) {
        if (propertyKey == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        this.key = propertyKey;
        this.listener = new DockPropertyListener<A>(){

            @Override
            public void propertyChanged(DockProperties dockProperties, PropertyKey<A> propertyKey, A a, A a2) {
                if (PropertyValue.this.value == null) {
                    PropertyValue.this.valueChanged(a, a2);
                }
            }
        };
        this.setProperties(dockController);
    }

    public void setProperties(DockController dockController) {
        if (dockController == null) {
            this.setProperties((DockProperties)null);
        } else {
            this.setProperties(dockController.getProperties());
        }
    }

    public void setProperties(DockProperties dockProperties) {
        if (this.value != null) {
            this.properties = dockProperties;
        } else {
            A a = this.getValue();
            if (this.properties != null) {
                this.properties.removeListener(this.key, this.listener);
            }
            this.properties = dockProperties;
            if (dockProperties != null) {
                dockProperties.addListener(this.key, this.listener);
            }
            A a2 = this.getValue();
            if (a == null && a2 != null || a != null && a2 == null || a != null && !a.equals(a2)) {
                this.valueChanged(a, a2);
            }
        }
    }

    public DockProperties getProperties() {
        return this.properties;
    }

    public PropertyKey<A> getKey() {
        return this.key;
    }

    public void setKey(PropertyKey<A> propertyKey) {
        if (propertyKey == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.properties == null) {
            this.key = propertyKey;
        } else {
            A a = this.getValue();
            this.properties.removeListener(this.key, this.listener);
            this.key = propertyKey;
            this.properties.addListener(this.key, this.listener);
            A a2 = this.getValue();
            if (a == null && a2 != null || a != null && a2 == null || a != null && !a.equals(a2)) {
                this.valueChanged(a, a2);
            }
        }
    }

    public A getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.properties != null) {
            return this.properties.get(this.key);
        }
        return this.key.getDefault(null);
    }

    public A getOwnValue() {
        return this.value;
    }

    public boolean isAnyValueSet() {
        if (this.value != null) {
            return true;
        }
        return this.properties != null && this.properties.isSet(this.key);
    }

    public void setValue(A a) {
        if (this.properties != null) {
            if (this.value == null && a != null) {
                this.properties.removeListener(this.key, this.listener);
            } else if (this.value != null && a == null) {
                this.properties.addListener(this.key, this.listener);
            }
        }
        A a2 = this.getValue();
        this.value = a;
        A a3 = this.getValue();
        if (a2 == null && a3 != null || a2 != null && a3 == null || a2 != null && !a2.equals(a3)) {
            this.valueChanged(a2, a3);
        }
    }

    protected abstract void valueChanged(A var1, A var2);

    public String toString() {
        return this.getClass().getName() + "[" + this.key.toString() + " -> " + this.getValue() + "]";
    }
}

