/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.editor;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import java.awt.Component;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditor
extends JTextField
implements PreferenceEditor<String> {
    public static final PreferenceEditorFactory<String> FACTORY = new PreferenceEditorFactory<String>(){

        @Override
        public PreferenceEditor<String> create() {
            return new StringEditor();
        }
    };
    private PreferenceEditorCallback<String> callback;
    private boolean onUpdate = false;

    public StringEditor() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                StringEditor.this.update(true);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                StringEditor.this.update(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                StringEditor.this.update(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(boolean bl) {
        try {
            this.onUpdate = true;
            if (this.callback != null) {
                this.callback.setOperation(PreferenceOperation.DELETE, this.getText().length() > 0);
                if (bl) {
                    this.callback.set(this.getText());
                }
            }
        }
        finally {
            this.onUpdate = false;
        }
    }

    @Override
    public void doOperation(PreferenceOperation preferenceOperation) {
        if (preferenceOperation == PreferenceOperation.DELETE) {
            this.setText("");
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public void setCallback(PreferenceEditorCallback<String> preferenceEditorCallback) {
        this.callback = preferenceEditorCallback;
        this.update(false);
    }

    @Override
    public void setValue(String string) {
        if (!this.onUpdate) {
            this.setText(string == null ? "" : string);
            this.update(false);
        }
    }

    @Override
    public void setValueInfo(Object object) {
    }
}

